/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporter;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpMetricExporter
implements MetricExporter {
    private final OkHttpExporter<MetricsRequestMarshaler> delegate;
    private final AggregationTemporality preferredTemporality;

    OtlpHttpMetricExporter(OkHttpExporter<MetricsRequestMarshaler> delegate, AggregationTemporality preferredTemporality) {
        this.delegate = delegate;
        this.preferredTemporality = preferredTemporality;
    }

    public static OtlpHttpMetricExporter getDefault() {
        return OtlpHttpMetricExporter.builder().build();
    }

    public static OtlpHttpMetricExporterBuilder builder() {
        return new OtlpHttpMetricExporterBuilder();
    }

    public AggregationTemporality getPreferredTemporality() {
        return this.preferredTemporality;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricsRequestMarshaler exportRequest = MetricsRequestMarshaler.create(metrics);
        return this.delegate.export((Marshaler)exportRequest, metrics.size());
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

