/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.trace;

import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.okhttp.OkHttpExporter;
import io.opentelemetry.exporter.otlp.internal.traces.TraceRequestMarshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpSpanExporter
implements SpanExporter {
    private final OkHttpExporter<TraceRequestMarshaler> delegate;

    OtlpHttpSpanExporter(OkHttpExporter<TraceRequestMarshaler> delegate) {
        this.delegate = delegate;
    }

    public static OtlpHttpSpanExporter getDefault() {
        return OtlpHttpSpanExporter.builder().build();
    }

    public static OtlpHttpSpanExporterBuilder builder() {
        return new OtlpHttpSpanExporterBuilder();
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        TraceRequestMarshaler exportRequest = TraceRequestMarshaler.create(spans);
        return this.delegate.export((Marshaler)exportRequest, spans.size());
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

