/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.http.logs;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporter;
import io.opentelemetry.exporter.internal.okhttp.OkHttpExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.OtlpUserAgent;
import io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class OtlpHttpLogRecordExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/logs";
    private final OkHttpExporterBuilder<LogsRequestMarshaler> delegate = new OkHttpExporterBuilder("otlp", "log", "http://localhost:4318/v1/logs");

    OtlpHttpLogRecordExporterBuilder() {
        OtlpUserAgent.addUserAgentHeader((arg_0, arg_1) -> this.delegate.addHeader(arg_0, arg_1));
    }

    public OtlpHttpLogRecordExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        return this.setTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpLogRecordExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder addHeader(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.configureTrustManager(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.configureKeyManager(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpLogRecordExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(meterProvider);
        return this;
    }

    public OtlpHttpLogRecordExporter build() {
        return new OtlpHttpLogRecordExporter((OkHttpExporter<LogsRequestMarshaler>)this.delegate.build());
    }
}

