/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.logs;

import io.opentelemetry.exporter.otlp.internal.Marshaler;
import io.opentelemetry.exporter.otlp.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.otlp.internal.logs.LogsRequestMarshaler;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogData;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcLogExporter
implements LogExporter {
    private final GrpcExporter<LogsRequestMarshaler> delegate;

    public static OtlpGrpcLogExporter getDefault() {
        return OtlpGrpcLogExporter.builder().build();
    }

    public static OtlpGrpcLogExporterBuilder builder() {
        return new OtlpGrpcLogExporterBuilder();
    }

    OtlpGrpcLogExporter(GrpcExporter<LogsRequestMarshaler> delegate) {
        this.delegate = delegate;
    }

    public CompletableResultCode export(Collection<LogData> logs) {
        LogsRequestMarshaler request = LogsRequestMarshaler.create(logs);
        return this.delegate.export((Marshaler)request, logs.size());
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

