/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.metrics;

import io.grpc.ManagedChannel;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.exporter.otlp.metrics.MarshalerMetricsServiceGrpc;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class OtlpGrpcMetricExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.metrics.v1.MetricsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.metrics.v1.MetricsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private static final Function<InstrumentType, AggregationTemporality> DEFAULT_AGGREGATION_TEMPORALITY_FUNCTION = MetricExporter::alwaysCumulative;
    final GrpcExporterBuilder<MetricsRequestMarshaler> delegate;
    private Function<InstrumentType, AggregationTemporality> aggregationTemporalityFunction = DEFAULT_AGGREGATION_TEMPORALITY_FUNCTION;

    OtlpGrpcMetricExporterBuilder() {
        this.delegate = GrpcExporter.builder((String)"metric", (long)10L, (URI)DEFAULT_ENDPOINT, () -> MarshalerMetricsServiceGrpc::newFutureStub, (String)GRPC_SERVICE_NAME, (String)GRPC_ENDPOINT_PATH);
    }

    @Deprecated
    public OtlpGrpcMetricExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.delegate.setTimeout(timeout);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustedCertificates(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setClientTls(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public OtlpGrpcMetricExporterBuilder setAggregationTemporality(Function<InstrumentType, AggregationTemporality> aggregationTemporalityFunction) {
        Objects.requireNonNull(aggregationTemporalityFunction, "aggregationTemporalityFunction");
        this.aggregationTemporalityFunction = aggregationTemporalityFunction;
        return this;
    }

    public OtlpGrpcMetricExporter build() {
        return new OtlpGrpcMetricExporter((GrpcExporter<MetricsRequestMarshaler>)this.delegate.build(), this.aggregationTemporalityFunction);
    }
}

