/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.metrics;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.opentelemetry.exporter.otlp.internal.MetricAdapter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import io.opentelemetry.proto.collector.metrics.v1.MetricsServiceGrpc;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private static final Logger internalLogger = Logger.getLogger(OtlpGrpcMetricExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final MetricsServiceGrpc.MetricsServiceFutureStub metricsService;
    private final ManagedChannel managedChannel;
    private final long timeoutNanos;

    OtlpGrpcMetricExporter(ManagedChannel channel, long timeoutNanos) {
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        this.metricsService = MetricsServiceGrpc.newFutureStub((Channel)channel);
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        ExportMetricsServiceRequest exportMetricsServiceRequest = ExportMetricsServiceRequest.newBuilder().addAllResourceMetrics((Iterable)MetricAdapter.toProtoResourceMetrics(metrics)).build();
        final CompletableResultCode result = new CompletableResultCode();
        MetricsServiceGrpc.MetricsServiceFutureStub exporter = this.timeoutNanos > 0L ? (MetricsServiceGrpc.MetricsServiceFutureStub)this.metricsService.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS) : this.metricsService;
        Futures.addCallback((ListenableFuture)exporter.export(exportMetricsServiceRequest), (FutureCallback)new FutureCallback<ExportMetricsServiceResponse>(){

            public void onSuccess(@Nullable ExportMetricsServiceResponse response) {
                result.succeed();
            }

            public void onFailure(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        OtlpGrpcMetricExporter.this.logger.log(Level.SEVERE, "Failed to export metrics. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. Full error message: " + t.getMessage());
                        break;
                    }
                    case UNAVAILABLE: {
                        OtlpGrpcMetricExporter.this.logger.log(Level.SEVERE, "Failed to export metrics. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network." + t.getMessage());
                        break;
                    }
                    default: {
                        OtlpGrpcMetricExporter.this.logger.log(Level.WARNING, "Failed to export metrics. Error message: " + t.getMessage());
                    }
                }
                OtlpGrpcMetricExporter.this.logger.log(Level.FINEST, "Failed to export metrics. Details follow: " + t);
                result.fail();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public CompletableResultCode shutdown() {
        try {
            this.managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.WARNING, "Failed to shutdown the gRPC channel", (Throwable)e);
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }
}

