/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.trace;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Channel;
import io.grpc.Codec;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundLongCounter;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.exporter.otlp.internal.TraceRequestMarshaler;
import io.opentelemetry.exporter.otlp.internal.grpc.ManagedChannelUtil;
import io.opentelemetry.exporter.otlp.trace.ExportTraceServiceResponse;
import io.opentelemetry.exporter.otlp.trace.MarshalerTraceServiceGrpc;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private static final AttributeKey<String> EXPORTER_KEY = AttributeKey.stringKey((String)"exporter");
    private static final AttributeKey<String> SUCCESS_KEY = AttributeKey.stringKey((String)"success");
    private static final String EXPORTER_NAME = OtlpGrpcSpanExporter.class.getSimpleName();
    private static final Attributes EXPORTER_NAME_Attributes = Attributes.of(EXPORTER_KEY, (Object)EXPORTER_NAME);
    private static final Attributes EXPORT_SUCCESS_ATTRIBUTES = Attributes.of(EXPORTER_KEY, (Object)EXPORTER_NAME, SUCCESS_KEY, (Object)"true");
    private static final Attributes EXPORT_FAILURE_ATTRIBUTES = Attributes.of(EXPORTER_KEY, (Object)EXPORTER_NAME, SUCCESS_KEY, (Object)"false");
    private static final Logger internalLogger = Logger.getLogger(OtlpGrpcSpanExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final MarshalerTraceServiceGrpc.TraceServiceFutureStub traceService;
    private final ManagedChannel managedChannel;
    private final long timeoutNanos;
    private final BoundLongCounter spansSeen;
    private final BoundLongCounter spansExportedSuccess;
    private final BoundLongCounter spansExportedFailure;

    OtlpGrpcSpanExporter(ManagedChannel channel, long timeoutNanos, boolean compressionEnabled) {
        Meter meter = GlobalMeterProvider.get().meterBuilder("io.opentelemetry.exporters.otlp").build();
        this.spansSeen = meter.counterBuilder("spansSeenByExporter").build().bind(EXPORTER_NAME_Attributes);
        LongCounter spansExportedCounter = meter.counterBuilder("spansExportedByExporter").build();
        this.spansExportedSuccess = spansExportedCounter.bind(EXPORT_SUCCESS_ATTRIBUTES);
        this.spansExportedFailure = spansExportedCounter.bind(EXPORT_FAILURE_ATTRIBUTES);
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        Codec codec = compressionEnabled ? new Codec.Gzip() : Codec.Identity.NONE;
        this.traceService = (MarshalerTraceServiceGrpc.TraceServiceFutureStub)MarshalerTraceServiceGrpc.newFutureStub((Channel)channel).withCompression(codec.getMessageEncoding());
    }

    public CompletableResultCode export(final Collection<SpanData> spans) {
        this.spansSeen.add((long)spans.size());
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        final CompletableResultCode result = new CompletableResultCode();
        MarshalerTraceServiceGrpc.TraceServiceFutureStub exporter = this.timeoutNanos > 0L ? (MarshalerTraceServiceGrpc.TraceServiceFutureStub)this.traceService.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS) : this.traceService;
        Futures.addCallback(exporter.export(request), (FutureCallback)new FutureCallback<ExportTraceServiceResponse>(){

            public void onSuccess(@Nullable ExportTraceServiceResponse response) {
                OtlpGrpcSpanExporter.this.spansExportedSuccess.add((long)spans.size());
                result.succeed();
            }

            public void onFailure(Throwable t) {
                OtlpGrpcSpanExporter.this.spansExportedFailure.add((long)spans.size());
                Status status = Status.fromThrowable((Throwable)t);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.SEVERE, "Failed to export spans. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. Full error message: " + t.getMessage());
                        break;
                    }
                    case UNAVAILABLE: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.SEVERE, "Failed to export spans. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + t.getMessage());
                        break;
                    }
                    default: {
                        OtlpGrpcSpanExporter.this.logger.log(Level.WARNING, "Failed to export spans. Error message: " + t.getMessage());
                    }
                }
                if (OtlpGrpcSpanExporter.this.logger.isLoggable(Level.FINEST)) {
                    OtlpGrpcSpanExporter.this.logger.log(Level.FINEST, "Failed to export spans. Details follow: " + t);
                }
                result.fail();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public CompletableResultCode shutdown() {
        if (this.managedChannel.isTerminated()) {
            return CompletableResultCode.ofSuccess();
        }
        this.spansSeen.unbind();
        this.spansExportedSuccess.unbind();
        this.spansExportedFailure.unbind();
        return ManagedChannelUtil.shutdownChannel((ManagedChannel)this.managedChannel);
    }

    long getTimeoutNanos() {
        return this.timeoutNanos;
    }
}

