/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.logs;

import io.grpc.ManagedChannel;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import io.opentelemetry.exporter.otlp.logs.MarshalerLogsServiceGrpc;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpGrpcLogRecordExporterBuilder {
    private static final String GRPC_SERVICE_NAME = "opentelemetry.proto.collector.logs.v1.LogsService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.logs.v1.LogsService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    final GrpcExporterBuilder<LogsRequestMarshaler> delegate;

    OtlpGrpcLogRecordExporterBuilder(GrpcExporterBuilder<LogsRequestMarshaler> delegate) {
        this.delegate = delegate;
        OtlpUserAgent.addUserAgentHeader((arg_0, arg_1) -> delegate.addConstantHeader(arg_0, arg_1));
    }

    OtlpGrpcLogRecordExporterBuilder() {
        this((GrpcExporterBuilder<LogsRequestMarshaler>)new GrpcExporterBuilder("otlp", "log", 10L, DEFAULT_ENDPOINT, () -> MarshalerLogsServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH));
    }

    @Deprecated
    public OtlpGrpcLogRecordExporterBuilder setChannel(ManagedChannel channel) {
        this.delegate.setChannel(channel);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.delegate.setTimeout(timeout, unit);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.delegate.setTimeout(timeout);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(compressionMethod);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeader(key, value);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.setMeterProvider(() -> meterProvider);
        return this;
    }

    public OtlpGrpcLogRecordExporterBuilder setMeterProvider(Supplier<MeterProvider> meterProviderSupplier) {
        Objects.requireNonNull(meterProviderSupplier, "meterProviderSupplier");
        this.delegate.setMeterProvider(meterProviderSupplier);
        return this;
    }

    public OtlpGrpcLogRecordExporter build() {
        return new OtlpGrpcLogRecordExporter(this.delegate, (GrpcExporter<LogsRequestMarshaler>)this.delegate.build());
    }
}

