/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.prometheus.metrics.model.snapshots.Unit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

class PrometheusUnitsHelper {
    private static final Map<String, String> pluralNames = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> singularNames = new ConcurrentHashMap<String, String>();
    private static final Map<String, Unit> predefinedUnits = new ConcurrentHashMap<String, Unit>();

    private PrometheusUnitsHelper() {
    }

    private static void initUnit(String otelName, String pluralName) {
        pluralNames.put(otelName, pluralName);
        predefinedUnits.put(otelName, new Unit(pluralName));
    }

    private static void initUnit(String otelName, String pluralName, String singularName) {
        PrometheusUnitsHelper.initUnit(otelName, pluralName);
        singularNames.put(otelName, singularName);
    }

    @Nullable
    static Unit convertUnit(String otelUnit) {
        if (otelUnit.isEmpty() || otelUnit.equals("1")) {
            return null;
        }
        if (otelUnit.contains("{") && ((otelUnit = otelUnit.replaceAll("\\{[^}]*}", "").trim()).isEmpty() || otelUnit.equals("/"))) {
            return null;
        }
        if (predefinedUnits.containsKey(otelUnit)) {
            return predefinedUnits.get(otelUnit);
        }
        if (otelUnit.contains("/")) {
            String[] parts = otelUnit.split("/", 2);
            String part1 = pluralNames.getOrDefault(parts[0], parts[0]).trim();
            String part2 = singularNames.getOrDefault(parts[1], parts[1]).trim();
            if (part1.isEmpty()) {
                return new Unit("per_" + part2);
            }
            return new Unit(part1 + "_per_" + part2);
        }
        return new Unit(otelUnit);
    }

    static {
        PrometheusUnitsHelper.initUnit("a", "years", "year");
        PrometheusUnitsHelper.initUnit("mo", "months", "month");
        PrometheusUnitsHelper.initUnit("wk", "weeks", "week");
        PrometheusUnitsHelper.initUnit("d", "days", "day");
        PrometheusUnitsHelper.initUnit("h", "hours", "hour");
        PrometheusUnitsHelper.initUnit("min", "minutes", "minute");
        PrometheusUnitsHelper.initUnit("s", "seconds", "second");
        PrometheusUnitsHelper.initUnit("ms", "milliseconds", "millisecond");
        PrometheusUnitsHelper.initUnit("us", "microseconds", "microsecond");
        PrometheusUnitsHelper.initUnit("ns", "nanoseconds", "nanosecond");
        PrometheusUnitsHelper.initUnit("By", "bytes", "byte");
        PrometheusUnitsHelper.initUnit("KiBy", "kibibytes", "kibibyte");
        PrometheusUnitsHelper.initUnit("MiBy", "mebibytes", "mebibyte");
        PrometheusUnitsHelper.initUnit("GiBy", "gibibytes", "gibibyte");
        PrometheusUnitsHelper.initUnit("TiBy", "tibibytes", "tibibyte");
        PrometheusUnitsHelper.initUnit("KBy", "kilobytes", "kilobyte");
        PrometheusUnitsHelper.initUnit("MBy", "megabytes", "megabyte");
        PrometheusUnitsHelper.initUnit("GBy", "gigabytes", "gigabyte");
        PrometheusUnitsHelper.initUnit("TBy", "terabytes", "terabyte");
        PrometheusUnitsHelper.initUnit("m", "meters", "meter");
        PrometheusUnitsHelper.initUnit("V", "volts", "volt");
        PrometheusUnitsHelper.initUnit("A", "amperes", "ampere");
        PrometheusUnitsHelper.initUnit("J", "joules", "joule");
        PrometheusUnitsHelper.initUnit("W", "watts", "watt");
        PrometheusUnitsHelper.initUnit("g", "grams", "gram");
        PrometheusUnitsHelper.initUnit("Cel", "celsius");
        PrometheusUnitsHelper.initUnit("Hz", "hertz");
        PrometheusUnitsHelper.initUnit("%", "percent");
        PrometheusUnitsHelper.initUnit("1", "ratio");
    }
}

