/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import com.sun.net.httpserver.HttpHandler;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusMetricReader;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import io.prometheus.metrics.exporter.httpserver.MetricsHandler;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class PrometheusHttpServer
implements MetricReader {
    private final HTTPServer httpServer;
    private final PrometheusMetricReader prometheusMetricReader;
    private final PrometheusRegistry prometheusRegistry;
    private final String host;

    public static PrometheusHttpServer create() {
        return PrometheusHttpServer.builder().build();
    }

    public static PrometheusHttpServerBuilder builder() {
        return new PrometheusHttpServerBuilder();
    }

    PrometheusHttpServer(String host, int port, @Nullable ExecutorService executor, PrometheusRegistry prometheusRegistry, boolean otelScopeEnabled, @Nullable Predicate<String> allowedResourceAttributesFilter) {
        this.prometheusMetricReader = new PrometheusMetricReader(otelScopeEnabled, allowedResourceAttributesFilter);
        this.host = host;
        this.prometheusRegistry = prometheusRegistry;
        prometheusRegistry.register((MultiCollector)this.prometheusMetricReader);
        try {
            this.httpServer = HTTPServer.builder().hostname(host).port(port).executorService(executor).registry(prometheusRegistry).defaultHandler((HttpHandler)new MetricsHandler(prometheusRegistry)).buildAndStart();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not create Prometheus HTTP server", e);
        }
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.prometheusMetricReader.getAggregationTemporality(instrumentType);
    }

    public void register(CollectionRegistration registration) {
        this.prometheusMetricReader.register(registration);
    }

    public CompletableResultCode forceFlush() {
        return this.prometheusMetricReader.forceFlush();
    }

    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        Runnable shutdownFunction = () -> {
            try {
                this.prometheusRegistry.unregister((MultiCollector)this.prometheusMetricReader);
                this.httpServer.stop();
                this.prometheusMetricReader.shutdown().whenComplete(() -> ((CompletableResultCode)result).succeed());
            }
            catch (Throwable t) {
                result.fail();
            }
        };
        Thread shutdownThread = new Thread(shutdownFunction, "prometheus-httpserver-shutdown");
        shutdownThread.setDaemon(true);
        shutdownThread.start();
        return result;
    }

    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "PrometheusHttpServer{address=" + this.getAddress() + "}";
    }

    InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.httpServer.getPort());
    }
}

