/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpHandler;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusMetricReader;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class PrometheusHttpServer
implements MetricReader {
    private final String host;
    private final int port;
    @Nullable
    private final Predicate<String> allowedResourceAttributesFilter;
    private final MemoryMode memoryMode;
    private final DefaultAggregationSelector defaultAggregationSelector;
    private final PrometheusHttpServerBuilder builder;
    private final HTTPServer httpServer;
    private final PrometheusMetricReader prometheusMetricReader;
    private final PrometheusRegistry prometheusRegistry;

    public static PrometheusHttpServer create() {
        return PrometheusHttpServer.builder().build();
    }

    public static PrometheusHttpServerBuilder builder() {
        return new PrometheusHttpServerBuilder();
    }

    PrometheusHttpServer(PrometheusHttpServerBuilder builder, String host, int port, @Nullable ExecutorService executor, PrometheusRegistry prometheusRegistry, @Nullable Predicate<String> allowedResourceAttributesFilter, MemoryMode memoryMode, @Nullable HttpHandler defaultHandler, DefaultAggregationSelector defaultAggregationSelector, @Nullable Authenticator authenticator) {
        this.host = host;
        this.port = port;
        this.allowedResourceAttributesFilter = allowedResourceAttributesFilter;
        this.memoryMode = memoryMode;
        this.defaultAggregationSelector = defaultAggregationSelector;
        this.builder = builder;
        this.prometheusMetricReader = new PrometheusMetricReader(allowedResourceAttributesFilter);
        this.prometheusRegistry = prometheusRegistry;
        prometheusRegistry.register((MultiCollector)this.prometheusMetricReader);
        if (memoryMode == MemoryMode.REUSABLE_DATA) {
            executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("prometheus-http-server"));
        }
        try {
            this.httpServer = HTTPServer.builder().hostname(host).port(port).executorService(executor).registry(prometheusRegistry).defaultHandler(defaultHandler).authenticator(authenticator).buildAndStart();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not create Prometheus HTTP server", e);
        }
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.prometheusMetricReader.getAggregationTemporality(instrumentType);
    }

    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public void register(CollectionRegistration registration) {
        this.prometheusMetricReader.register(registration);
    }

    public CompletableResultCode forceFlush() {
        return this.prometheusMetricReader.forceFlush();
    }

    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        Runnable shutdownFunction = () -> {
            try {
                this.prometheusRegistry.unregister((MultiCollector)this.prometheusMetricReader);
                this.httpServer.stop();
                this.prometheusMetricReader.shutdown().whenComplete(() -> ((CompletableResultCode)result).succeed());
            }
            catch (Throwable t) {
                result.fail();
            }
        };
        Thread shutdownThread = new Thread(shutdownFunction, "prometheus-httpserver-shutdown");
        shutdownThread.setDaemon(true);
        shutdownThread.start();
        return result;
    }

    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "PrometheusHttpServer{", "}");
        joiner.add("host=" + this.host);
        joiner.add("port=" + this.port);
        joiner.add("allowedResourceAttributesFilter=" + this.allowedResourceAttributesFilter);
        joiner.add("memoryMode=" + this.memoryMode);
        joiner.add("defaultAggregationSelector=" + DefaultAggregationSelector.asString((DefaultAggregationSelector)this.defaultAggregationSelector));
        return joiner.toString();
    }

    public PrometheusHttpServerBuilder toBuilder() {
        return new PrometheusHttpServerBuilder(this.builder);
    }

    InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.httpServer.getPort());
    }
}

