/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.grpc.managedchannel.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UpstreamGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    private final MarshalerServiceStub<T, ?, ?> stub;
    private final long timeoutNanos;

    public UpstreamGrpcSender(MarshalerServiceStub<T, ?, ?> stub, long timeoutNanos) {
        this.timeoutNanos = timeoutNanos;
        this.stub = stub;
    }

    public void send(T request, final Runnable onSuccess, final BiConsumer<GrpcResponse, Throwable> onError) {
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        Futures.addCallback((ListenableFuture)stub.export(request), (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object unused) {
                onSuccess.run();
            }

            public void onFailure(Throwable t) {
                Status status = Status.fromThrowable((Throwable)t);
                onError.accept(GrpcResponse.create((int)status.getCode().value(), (String)status.getDescription()), t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }
}

