/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.grpc.managedchannel.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.MetadataUtils;
import io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class UpstreamGrpcSender<T extends Marshaler>
implements GrpcSender<T> {
    private final MarshalerServiceStub<T, ?, ?> stub;
    private final boolean shutdownChannel;
    private final long timeoutNanos;
    private final Supplier<Map<String, List<String>>> headersSupplier;

    public UpstreamGrpcSender(MarshalerServiceStub<T, ?, ?> stub, boolean shutdownChannel, long timeoutNanos, Supplier<Map<String, List<String>>> headersSupplier) {
        this.stub = stub;
        this.shutdownChannel = shutdownChannel;
        this.timeoutNanos = timeoutNanos;
        this.headersSupplier = headersSupplier;
    }

    public void send(T request, final Consumer<GrpcResponse> onResponse, final Consumer<Throwable> onError) {
        Map<String, List<String>> headers;
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(Duration.ofNanos(this.timeoutNanos));
        }
        if ((headers = this.headersSupplier.get()) != null) {
            Metadata metadata = new Metadata();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                metadata.put(Metadata.Key.of((String)entry.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
            }
            stub = (MarshalerServiceStub)stub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
        }
        Futures.addCallback((ListenableFuture)stub.export(request), (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object unused) {
                onResponse.accept(GrpcResponse.create((int)Status.OK.getCode().value(), (String)Status.OK.getDescription()));
            }

            public void onFailure(Throwable t) {
                Status status = UpstreamGrpcSender.fromThrowable(t);
                if (status == null) {
                    onError.accept(t);
                } else {
                    onResponse.accept(GrpcResponse.create((int)status.getCode().value(), (String)status.getDescription()));
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Nullable
    private static Status fromThrowable(Throwable cause) {
        while (cause != null) {
            if (cause instanceof StatusException) {
                return ((StatusException)cause).getStatus();
            }
            if (cause instanceof StatusRuntimeException) {
                return ((StatusRuntimeException)cause).getStatus();
            }
            cause = cause.getCause();
        }
        return null;
    }

    public CompletableResultCode shutdown() {
        if (this.shutdownChannel) {
            ManagedChannel channel = (ManagedChannel)this.stub.getChannel();
            channel.shutdownNow();
        }
        return CompletableResultCode.ofSuccess();
    }
}

