/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.grpc.managedchannel.internal;

import io.grpc.Channel;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.grpc.GrpcSenderConfig;
import io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider;
import io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.sender.grpc.managedchannel.internal.UpstreamGrpcSender;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class UpstreamGrpcSenderProvider
implements GrpcSenderProvider {
    public <T extends Marshaler> GrpcSender<T> createSender(GrpcSenderConfig<T> grpcSenderConfig) {
        boolean shutdownChannel = false;
        Object managedChannel = grpcSenderConfig.getManagedChannel();
        if (managedChannel == null) {
            shutdownChannel = true;
            managedChannel = UpstreamGrpcSenderProvider.minimalFallbackManagedChannel(grpcSenderConfig.getEndpoint());
        }
        String authorityOverride = null;
        Map headers = (Map)grpcSenderConfig.getHeadersSupplier().get();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                if (!((String)entry.getKey()).equals("host") || ((List)entry.getValue()).isEmpty()) continue;
                authorityOverride = (String)((List)entry.getValue()).get(0);
            }
        }
        String compression = Codec.Identity.NONE.getMessageEncoding();
        final io.opentelemetry.exporter.internal.compression.Compressor compressor = grpcSenderConfig.getCompressor();
        if (compressor != null) {
            CompressorRegistry.getDefaultInstance().register(new Compressor(){

                public String getMessageEncoding() {
                    return compressor.getEncoding();
                }

                public OutputStream compress(OutputStream os) throws IOException {
                    return compressor.compress(os);
                }
            });
            compression = compressor.getEncoding();
        }
        MarshalerServiceStub stub = (MarshalerServiceStub)((MarshalerServiceStub)((BiFunction)grpcSenderConfig.getStubFactory().get()).apply((Channel)managedChannel, authorityOverride)).withCompression(compression);
        return new UpstreamGrpcSender(stub, shutdownChannel, grpcSenderConfig.getTimeoutNanos(), grpcSenderConfig.getHeadersSupplier());
    }

    private static ManagedChannel minimalFallbackManagedChannel(URI endpoint) {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)endpoint.getHost(), (int)endpoint.getPort());
        if (!endpoint.getScheme().equals("https")) {
            channelBuilder.usePlaintext();
        }
        return channelBuilder.build();
    }
}

