/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.zipkin.LocalInetAddressSupplier;
import io.opentelemetry.exporter.zipkin.OtelToZipkinSpanTransformer;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

public final class ZipkinSpanExporterBuilder {
    private BytesEncoder<Span> encoder = SpanBytesEncoder.JSON_V2;
    private Supplier<InetAddress> localIpAddressSupplier = LocalInetAddressSupplier.getInstance();
    @Nullable
    private Sender sender;
    private String endpoint = "http://localhost:9411/api/v2/spans";
    private boolean compressionEnabled = true;
    private long readTimeoutMillis = TimeUnit.SECONDS.toMillis(10L);
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;

    public ZipkinSpanExporterBuilder setSender(Sender sender) {
        Objects.requireNonNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    public ZipkinSpanExporterBuilder setEncoder(BytesEncoder<Span> encoder) {
        Objects.requireNonNull(encoder, "encoder");
        this.encoder = encoder;
        return this;
    }

    public ZipkinSpanExporterBuilder setLocalIpAddressSupplier(Supplier<InetAddress> supplier) {
        Objects.requireNonNull(supplier, "encoder");
        this.localIpAddressSupplier = supplier;
        return this;
    }

    public ZipkinSpanExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = endpoint;
        return this;
    }

    public ZipkinSpanExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Utils.checkArgument((compressionMethod.equals("gzip") || compressionMethod.equals("none") ? 1 : 0) != 0, (String)"Unsupported compression method. Supported compression methods include: gzip, none.");
        this.compressionEnabled = compressionMethod.equals("gzip");
        return this;
    }

    public ZipkinSpanExporterBuilder setReadTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must be non-negative");
        this.readTimeoutMillis = unit.toMillis(timeout);
        return this;
    }

    public ZipkinSpanExporterBuilder setReadTimeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.setReadTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    public ZipkinSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProviderSupplier = () -> meterProvider;
        return this;
    }

    public ZipkinSpanExporter build() {
        Sender sender = this.sender;
        if (sender == null) {
            sender = OkHttpSender.newBuilder().endpoint(this.endpoint).compressionEnabled(this.compressionEnabled).readTimeout((int)this.readTimeoutMillis).build();
        }
        OtelToZipkinSpanTransformer transformer = OtelToZipkinSpanTransformer.create(this.localIpAddressSupplier);
        return new ZipkinSpanExporter(this.encoder, sender, this.meterProviderSupplier, transformer);
    }
}

