/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.jaeger;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.opentelemetry.exporters.jaeger.proto.api_v2.Model;
import io.opentelemetry.exporters.otprotocol.TraceProtoUtils;
import io.opentelemetry.sdk.trace.SpanData;
import io.opentelemetry.trace.AttributeValue;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class Adapter {
    static final String KEY_LOG_MESSAGE = "message";
    static final String KEY_SPAN_KIND = "span.kind";
    static final String KEY_SPAN_STATUS_MESSAGE = "span.status.message";
    static final String KEY_SPAN_STATUS_CODE = "span.status.code";

    private Adapter() {
    }

    static Collection<Model.Span> toJaeger(List<SpanData> spans) {
        ArrayList<Model.Span> convertedList = new ArrayList<Model.Span>(spans.size());
        for (SpanData span : spans) {
            convertedList.add(Adapter.toJaeger(span));
        }
        return convertedList;
    }

    static Model.Span toJaeger(SpanData span) {
        Model.Span.Builder target = Model.Span.newBuilder();
        target.setTraceId(TraceProtoUtils.toProtoTraceId((TraceId)span.getTraceId()));
        target.setSpanId(TraceProtoUtils.toProtoSpanId((SpanId)span.getSpanId()));
        target.setOperationName(span.getName());
        Timestamp startTimestamp = Timestamps.fromNanos((long)span.getStartEpochNanos());
        target.setStartTime(startTimestamp);
        target.setDuration(Timestamps.between((Timestamp)startTimestamp, (Timestamp)Timestamps.fromNanos((long)span.getEndEpochNanos())));
        target.addAllTags(Adapter.toKeyValues(span.getAttributes()));
        target.addAllLogs(Adapter.toJaegerLogs(span.getTimedEvents()));
        target.addAllReferences(Adapter.toSpanRefs(span.getLinks()));
        if (span.getParentSpanId().isValid()) {
            target.addReferences(Model.SpanRef.newBuilder().setTraceId(TraceProtoUtils.toProtoTraceId((TraceId)span.getTraceId())).setSpanId(TraceProtoUtils.toProtoSpanId((SpanId)span.getParentSpanId())).setRefType(Model.SpanRefType.CHILD_OF));
        }
        if (span.getKind() != null) {
            target.addTags(Model.KeyValue.newBuilder().setKey(KEY_SPAN_KIND).setVStr(span.getKind().name()).build());
        }
        target.addTags(Model.KeyValue.newBuilder().setKey(KEY_SPAN_STATUS_MESSAGE).setVStr(span.getStatus().getDescription() == null ? "" : span.getStatus().getDescription()).build());
        target.addTags(Model.KeyValue.newBuilder().setKey(KEY_SPAN_STATUS_CODE).setVInt64(span.getStatus().getCanonicalCode().value()).setVType(Model.ValueType.INT64).build());
        return target.build();
    }

    @VisibleForTesting
    static Collection<Model.Log> toJaegerLogs(List<SpanData.TimedEvent> timeEvents) {
        ArrayList<Model.Log> logs = new ArrayList<Model.Log>(timeEvents.size());
        for (SpanData.TimedEvent e : timeEvents) {
            logs.add(Adapter.toJaegerLog(e));
        }
        return logs;
    }

    @VisibleForTesting
    static Model.Log toJaegerLog(SpanData.TimedEvent timedEvent) {
        Model.Log.Builder builder = Model.Log.newBuilder();
        builder.setTimestamp(Timestamps.fromNanos((long)timedEvent.getEpochNanos()));
        builder.addFields(Model.KeyValue.newBuilder().setKey(KEY_LOG_MESSAGE).setVStr(timedEvent.getName()).build());
        builder.addAllFields(Adapter.toKeyValues(timedEvent.getAttributes()));
        return builder.build();
    }

    @VisibleForTesting
    static Collection<Model.KeyValue> toKeyValues(Map<String, AttributeValue> attributes) {
        ArrayList<Model.KeyValue> tags = new ArrayList<Model.KeyValue>(attributes.size());
        for (Map.Entry<String, AttributeValue> entry : attributes.entrySet()) {
            tags.add(Adapter.toKeyValue(entry.getKey(), entry.getValue()));
        }
        return tags;
    }

    @VisibleForTesting
    static Model.KeyValue toKeyValue(String key, AttributeValue value) {
        Model.KeyValue.Builder builder = Model.KeyValue.newBuilder();
        builder.setKey(key);
        switch (value.getType()) {
            case STRING: {
                builder.setVStr(value.getStringValue());
                builder.setVType(Model.ValueType.STRING);
                break;
            }
            case LONG: {
                builder.setVInt64(value.getLongValue());
                builder.setVType(Model.ValueType.INT64);
                break;
            }
            case BOOLEAN: {
                builder.setVBool(value.getBooleanValue());
                builder.setVType(Model.ValueType.BOOL);
                break;
            }
            case DOUBLE: {
                builder.setVFloat64(value.getDoubleValue());
                builder.setVType(Model.ValueType.FLOAT64);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static Collection<Model.SpanRef> toSpanRefs(List<Link> links) {
        ArrayList<Model.SpanRef> spanRefs = new ArrayList<Model.SpanRef>(links.size());
        for (Link link : links) {
            spanRefs.add(Adapter.toSpanRef(link));
        }
        return spanRefs;
    }

    @VisibleForTesting
    static Model.SpanRef toSpanRef(Link link) {
        Model.SpanRef.Builder builder = Model.SpanRef.newBuilder();
        builder.setTraceId(TraceProtoUtils.toProtoTraceId((TraceId)link.getContext().getTraceId()));
        builder.setSpanId(TraceProtoUtils.toProtoSpanId((SpanId)link.getContext().getSpanId()));
        builder.setRefType(Model.SpanRefType.FOLLOWS_FROM);
        return builder.build();
    }
}

