/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.jaeger;

import io.grpc.Channel;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.opentelemetry.exporters.jaeger.Adapter;
import io.opentelemetry.exporters.jaeger.proto.api_v2.Collector;
import io.opentelemetry.exporters.jaeger.proto.api_v2.CollectorServiceGrpc;
import io.opentelemetry.exporters.jaeger.proto.api_v2.Model;
import io.opentelemetry.sdk.trace.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JaegerGrpcSpanExporter
implements SpanExporter {
    private static final Logger logger = Logger.getLogger(JaegerGrpcSpanExporter.class.getName());
    private static final String CLIENT_VERSION_KEY = "jaeger.version";
    private static final String CLIENT_VERSION_VALUE = "opentelemetry-java";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String HOSTNAME_DEFAULT = "(unknown)";
    private static final String IP_KEY = "ip";
    private static final String IP_DEFAULT = "0.0.0.0";
    private final CollectorServiceGrpc.CollectorServiceBlockingStub blockingStub;
    private final Model.Process process;
    private final ManagedChannel managedChannel;
    private final long deadline;

    private JaegerGrpcSpanExporter(String serviceName, ManagedChannel channel, long deadline) {
        String ipv4;
        String hostname;
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new IllegalArgumentException("Service name must not be null or empty");
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            ipv4 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostname = HOSTNAME_DEFAULT;
            ipv4 = IP_DEFAULT;
        }
        Model.KeyValue clientTag = Model.KeyValue.newBuilder().setKey(CLIENT_VERSION_KEY).setVStr(CLIENT_VERSION_VALUE).build();
        Model.KeyValue ipv4Tag = Model.KeyValue.newBuilder().setKey(IP_KEY).setVStr(ipv4).build();
        Model.KeyValue hostnameTag = Model.KeyValue.newBuilder().setKey(HOSTNAME_KEY).setVStr(hostname).build();
        this.process = Model.Process.newBuilder().setServiceName(serviceName).addTags(clientTag).addTags(ipv4Tag).addTags(hostnameTag).build();
        this.managedChannel = channel;
        this.blockingStub = CollectorServiceGrpc.newBlockingStub((Channel)channel);
        this.deadline = deadline;
    }

    public SpanExporter.ResultCode export(List<SpanData> spans) {
        Model.Batch.Builder builder = Model.Batch.newBuilder();
        builder.addAllSpans(Adapter.toJaeger(spans));
        builder.setProcess(this.process);
        Collector.PostSpansRequest.Builder requestBuilder = Collector.PostSpansRequest.newBuilder();
        requestBuilder.setBatch(builder.build());
        Collector.PostSpansRequest request = requestBuilder.build();
        try {
            CollectorServiceGrpc.CollectorServiceBlockingStub stub = this.blockingStub;
            if (this.deadline > 0L) {
                stub = (CollectorServiceGrpc.CollectorServiceBlockingStub)stub.withDeadline(Deadline.after((long)this.deadline, (TimeUnit)TimeUnit.MILLISECONDS));
            }
            stub.postSpans(request);
            return SpanExporter.ResultCode.SUCCESS;
        }
        catch (StatusRuntimeException e) {
            switch (e.getStatus().getCode()) {
                case DEADLINE_EXCEEDED: 
                case UNAVAILABLE: {
                    return SpanExporter.ResultCode.FAILED_RETRYABLE;
                }
            }
            return SpanExporter.ResultCode.FAILED_NOT_RETRYABLE;
        }
        catch (Throwable t) {
            return SpanExporter.ResultCode.FAILED_NOT_RETRYABLE;
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void shutdown() {
        try {
            this.managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Failed to shutdown the gRPC channel", e);
        }
    }

    public static class Builder {
        private String serviceName;
        private ManagedChannel channel;
        private long deadline = 1000L;

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this;
        }

        public Builder setDeadline(long deadline) {
            this.deadline = deadline;
            return this;
        }

        public JaegerGrpcSpanExporter build() {
            return new JaegerGrpcSpanExporter(this.serviceName, this.channel, this.deadline);
        }
    }
}

