/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.otlp;

import io.opentelemetry.common.LabelConsumer;
import io.opentelemetry.common.Labels;
import io.opentelemetry.exporters.otlp.CommonAdapter;
import io.opentelemetry.exporters.otlp.ResourceAdapter;
import io.opentelemetry.proto.common.v1.StringKeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.DoubleDataPoint;
import io.opentelemetry.proto.metrics.v1.DoubleHistogram;
import io.opentelemetry.proto.metrics.v1.DoubleHistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.DoubleSum;
import io.opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics;
import io.opentelemetry.proto.metrics.v1.IntDataPoint;
import io.opentelemetry.proto.metrics.v1.IntSum;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MetricAdapter {
    static List<ResourceMetrics> toProtoResourceMetrics(Collection<MetricData> metricData) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> resourceAndLibraryMap = MetricAdapter.groupByResourceAndLibrary(metricData);
        ArrayList<ResourceMetrics> resourceMetrics = new ArrayList<ResourceMetrics>(resourceAndLibraryMap.size());
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> entryResource : resourceAndLibraryMap.entrySet()) {
            ArrayList<InstrumentationLibraryMetrics> instrumentationLibraryMetrics = new ArrayList<InstrumentationLibraryMetrics>(entryResource.getValue().size());
            for (Map.Entry<InstrumentationLibraryInfo, List<Metric>> entryLibrary : entryResource.getValue().entrySet()) {
                instrumentationLibraryMetrics.add(InstrumentationLibraryMetrics.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(entryLibrary.getKey())).addAllMetrics((Iterable)entryLibrary.getValue()).build());
            }
            resourceMetrics.add(ResourceMetrics.newBuilder().setResource(ResourceAdapter.toProtoResource(entryResource.getKey())).addAllInstrumentationLibraryMetrics(instrumentationLibraryMetrics).build());
        }
        return resourceMetrics;
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> groupByResourceAndLibrary(Collection<MetricData> metricDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> result = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>>();
        for (MetricData metricData : metricDataList) {
            ArrayList<Metric> metricList;
            Resource resource = metricData.getResource();
            HashMap<InstrumentationLibraryInfo, ArrayList<Metric>> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, ArrayList<Metric>>)result.get(metricData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, ArrayList<Metric>>();
                result.put(resource, libraryInfoListMap);
            }
            if ((metricList = (ArrayList<Metric>)libraryInfoListMap.get(metricData.getInstrumentationLibraryInfo())) == null) {
                metricList = new ArrayList<Metric>();
                libraryInfoListMap.put(metricData.getInstrumentationLibraryInfo(), metricList);
            }
            metricList.add(MetricAdapter.toProtoMetric(metricData));
        }
        return result;
    }

    static Metric toProtoMetric(MetricData metricData) {
        Metric.Builder builder = Metric.newBuilder().setName(metricData.getName()).setDescription(metricData.getDescription()).setUnit(metricData.getUnit());
        if (metricData.getPoints().isEmpty()) {
            return builder.build();
        }
        boolean monotonic = false;
        switch (metricData.getType()) {
            case MONOTONIC_LONG: {
                monotonic = true;
            }
            case NON_MONOTONIC_LONG: {
                builder.setIntSum(IntSum.newBuilder().setIsMonotonic(monotonic).setAggregationTemporality(MetricAdapter.mapToTemporality(metricData.getType())).addAllDataPoints(MetricAdapter.toIntDataPoints(metricData.getPoints())).build());
                break;
            }
            case MONOTONIC_DOUBLE: {
                monotonic = true;
            }
            case NON_MONOTONIC_DOUBLE: {
                builder.setDoubleSum(DoubleSum.newBuilder().setIsMonotonic(monotonic).setAggregationTemporality(MetricAdapter.mapToTemporality(metricData.getType())).addAllDataPoints(MetricAdapter.toDoubleDataPoints(metricData.getPoints())).build());
                break;
            }
            case SUMMARY: {
                builder.setDoubleHistogram(DoubleHistogram.newBuilder().setAggregationTemporality(MetricAdapter.mapToTemporality(metricData.getType())).addAllDataPoints(MetricAdapter.toSummaryDataPoints(metricData.getPoints())).build());
            }
        }
        return builder.build();
    }

    private static AggregationTemporality mapToTemporality(MetricData.Type type) {
        switch (type) {
            case MONOTONIC_LONG: 
            case NON_MONOTONIC_LONG: 
            case MONOTONIC_DOUBLE: 
            case NON_MONOTONIC_DOUBLE: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
            }
            case SUMMARY: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
            }
        }
        return AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
    }

    static List<IntDataPoint> toIntDataPoints(Collection<MetricData.Point> points) {
        ArrayList<IntDataPoint> result = new ArrayList<IntDataPoint>(points.size());
        for (MetricData.Point point : points) {
            MetricData.LongPoint longPoint = (MetricData.LongPoint)point;
            IntDataPoint.Builder builder = IntDataPoint.newBuilder().setStartTimeUnixNano(longPoint.getStartEpochNanos()).setTimeUnixNano(longPoint.getEpochNanos()).setValue(longPoint.getValue());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(longPoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            result.add(builder.build());
        }
        return result;
    }

    static Collection<DoubleDataPoint> toDoubleDataPoints(Collection<MetricData.Point> points) {
        ArrayList<DoubleDataPoint> result = new ArrayList<DoubleDataPoint>(points.size());
        for (MetricData.Point point : points) {
            MetricData.DoublePoint doublePoint = (MetricData.DoublePoint)point;
            DoubleDataPoint.Builder builder = DoubleDataPoint.newBuilder().setStartTimeUnixNano(doublePoint.getStartEpochNanos()).setTimeUnixNano(doublePoint.getEpochNanos()).setValue(doublePoint.getValue());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(doublePoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            result.add(builder.build());
        }
        return result;
    }

    static List<DoubleHistogramDataPoint> toSummaryDataPoints(Collection<MetricData.Point> points) {
        ArrayList<DoubleHistogramDataPoint> result = new ArrayList<DoubleHistogramDataPoint>(points.size());
        for (MetricData.Point point : points) {
            MetricData.SummaryPoint summaryPoint = (MetricData.SummaryPoint)point;
            DoubleHistogramDataPoint.Builder builder = DoubleHistogramDataPoint.newBuilder().setStartTimeUnixNano(summaryPoint.getStartEpochNanos()).setTimeUnixNano(summaryPoint.getEpochNanos()).setCount(summaryPoint.getCount()).setSum(summaryPoint.getSum());
            List<StringKeyValue> labels = MetricAdapter.toProtoLabels(summaryPoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllLabels(labels);
            }
            if (!summaryPoint.getPercentileValues().isEmpty()) {
                MetricAdapter.addBucketValues(summaryPoint.getPercentileValues(), builder);
            }
            result.add(builder.build());
        }
        return result;
    }

    static void addBucketValues(List<MetricData.ValueAtPercentile> valueAtPercentiles, DoubleHistogramDataPoint.Builder builder) {
        for (MetricData.ValueAtPercentile valueAtPercentile : valueAtPercentiles) {
            builder.addBucketCounts((long)valueAtPercentile.getValue());
            builder.addExplicitBounds(valueAtPercentile.getPercentile());
        }
        builder.addBucketCounts(0L);
    }

    static List<StringKeyValue> toProtoLabels(Labels labels) {
        if (labels.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList<StringKeyValue> result = new ArrayList<StringKeyValue>(labels.size());
        labels.forEach(new LabelConsumer(){

            public void consume(String key, String value) {
                result.add(StringKeyValue.newBuilder().setKey(key).setValue(value).build());
            }
        });
        return result;
    }

    private MetricAdapter() {
    }
}

