/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.otprotocol;

import com.google.protobuf.ByteString;
import io.opentelemetry.proto.trace.v1.ConstantSampler;
import io.opentelemetry.proto.trace.v1.TraceConfig;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.Samplers;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceId;

public class TraceProtoUtils {
    private TraceProtoUtils() {
    }

    public static ByteString toProtoSpanId(SpanId spanId) {
        byte[] spanIdBytes = new byte[SpanId.getSize()];
        spanId.copyBytesTo(spanIdBytes, 0);
        return ByteString.copyFrom((byte[])spanIdBytes);
    }

    public static ByteString toProtoTraceId(TraceId traceId) {
        byte[] traceIdBytes = new byte[TraceId.getSize()];
        traceId.copyBytesTo(traceIdBytes, 0);
        return ByteString.copyFrom((byte[])traceIdBytes);
    }

    public static io.opentelemetry.sdk.trace.config.TraceConfig traceConfigFromProto(TraceConfig traceConfigProto) {
        return io.opentelemetry.sdk.trace.config.TraceConfig.getDefault().toBuilder().setSampler(TraceProtoUtils.fromProtoSampler(traceConfigProto)).setMaxNumberOfAttributes((int)traceConfigProto.getMaxNumberOfAttributes()).setMaxNumberOfEvents((int)traceConfigProto.getMaxNumberOfTimedEvents()).setMaxNumberOfLinks((int)traceConfigProto.getMaxNumberOfLinks()).setMaxNumberOfAttributesPerEvent((int)traceConfigProto.getMaxNumberOfAttributesPerTimedEvent()).setMaxNumberOfAttributesPerLink((int)traceConfigProto.getMaxNumberOfAttributesPerLink()).build();
    }

    private static Sampler fromProtoSampler(TraceConfig traceConfigProto) {
        if (traceConfigProto.hasConstantSampler()) {
            ConstantSampler constantSampler = traceConfigProto.getConstantSampler();
            switch (constantSampler.getDecision()) {
                case ALWAYS_ON: {
                    return Samplers.alwaysOn();
                }
                case ALWAYS_OFF: {
                    return Samplers.alwaysOff();
                }
                case ALWAYS_PARENT: 
                case UNRECOGNIZED: {
                    throw new IllegalArgumentException("unrecognized constant sampling decision");
                }
            }
        }
        if (traceConfigProto.hasProbabilitySampler()) {
            // empty if block
        }
        if (traceConfigProto.hasRateLimitingSampler()) {
            // empty if block
        }
        throw new IllegalArgumentException("unknown sampler in the trace config proto");
    }
}

