/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporters.prometheus;

import io.opentelemetry.exporters.prometheus.MetricAdapter;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class PrometheusCollector
extends Collector {
    private final MetricProducer metricProducer;

    private PrometheusCollector(MetricProducer metricProducer) {
        this.metricProducer = metricProducer;
    }

    public List<Collector.MetricFamilySamples> collect() {
        Collection allMetrics = this.metricProducer.collectAllMetrics();
        ArrayList<Collector.MetricFamilySamples> allSamples = new ArrayList<Collector.MetricFamilySamples>(allMetrics.size());
        for (MetricData metricData : allMetrics) {
            allSamples.add(MetricAdapter.toMetricFamilySamples(metricData));
        }
        return allSamples;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private MetricProducer metricProducer;

        public Builder setMetricProducer(MetricProducer metricProducer) {
            this.metricProducer = metricProducer;
            return this;
        }

        public PrometheusCollector build() {
            return new PrometheusCollector(Objects.requireNonNull(this.metricProducer, "metricProducer"));
        }

        public PrometheusCollector buildAndRegister() {
            return (PrometheusCollector)this.build().register();
        }
    }
}

