/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjector;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorInjectorMultipleHeaders
implements B3PropagatorInjector {
    B3PropagatorInjectorMultipleHeaders() {
    }

    @Override
    public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
        String sampled;
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(setter, "setter");
        SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        String string = sampled = spanContext.isSampled() ? "1" : "0";
        if (Boolean.TRUE.equals(context.get(B3Propagator.DEBUG_CONTEXT_KEY))) {
            setter.set(carrier, "X-B3-Flags", "1");
            sampled = "1";
        }
        setter.set(carrier, "X-B3-TraceId", spanContext.getTraceId());
        setter.set(carrier, "X-B3-SpanId", spanContext.getSpanId());
        setter.set(carrier, "X-B3-Sampled", sampled);
    }
}

