/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class StringUtils {
    static String padStart(String string, int minLength, char padChar) {
        Objects.requireNonNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    static String padLeft(String value, int minLength) {
        return StringUtils.padStart(value, minLength, '0');
    }

    private StringUtils() {
    }
}

