/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.micrometer1shim;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.micrometer1shim.Bridging;
import io.opentelemetry.micrometer1shim.DoubleMeasurementRecorder;
import io.opentelemetry.micrometer1shim.RemovableMeter;
import io.opentelemetry.micrometer1shim.UnsupportedReadLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class OpenTelemetryMeter
implements Meter,
RemovableMeter {
    private final Meter.Id id;
    private final List<AutoCloseable> observableInstruments;

    OpenTelemetryMeter(Meter.Id id, NamingConvention namingConvention, Iterable<Measurement> measurements, io.opentelemetry.api.metrics.Meter otelMeter) {
        this.id = id;
        Attributes attributes = Bridging.tagsAsAttributes(id, namingConvention);
        ArrayList<AutoCloseable> observableInstruments = new ArrayList<AutoCloseable>();
        for (Measurement measurement : measurements) {
            String name = Bridging.statisticInstrumentName(id, measurement.getStatistic(), namingConvention);
            String description = Bridging.description(id);
            String baseUnit = Bridging.baseUnit(id);
            DoubleMeasurementRecorder<Measurement> callback = new DoubleMeasurementRecorder<Measurement>(measurement, Measurement::getValue, attributes);
            switch (measurement.getStatistic()) {
                case TOTAL: 
                case TOTAL_TIME: 
                case COUNT: {
                    observableInstruments.add((AutoCloseable)otelMeter.counterBuilder(name).ofDoubles().setDescription(description).setUnit(baseUnit).buildWithCallback(callback));
                    break;
                }
                case ACTIVE_TASKS: {
                    observableInstruments.add((AutoCloseable)otelMeter.upDownCounterBuilder(name).ofDoubles().setDescription(description).setUnit(baseUnit).buildWithCallback(callback));
                    break;
                }
                case DURATION: 
                case MAX: 
                case VALUE: 
                case UNKNOWN: {
                    observableInstruments.add((AutoCloseable)otelMeter.gaugeBuilder(name).setDescription(description).setUnit(baseUnit).buildWithCallback(callback));
                }
            }
        }
        this.observableInstruments = observableInstruments;
    }

    public Meter.Id getId() {
        return this.id;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        try {
            for (AutoCloseable observableInstrument : this.observableInstruments) {
                observableInstrument.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("SDK instruments should never throw on close()", e);
        }
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

