/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.micrometer1shim;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.micrometer1shim.OpenTelemetryMeterRegistry;
import io.opentelemetry.micrometer1shim.PrometheusModeNamingConvention;
import java.util.concurrent.TimeUnit;

public final class OpenTelemetryMeterRegistryBuilder {
    static final String INSTRUMENTATION_NAME = "io.opentelemetry.micrometer1shim";
    private final OpenTelemetry openTelemetry;
    private Clock clock = Clock.SYSTEM;
    private TimeUnit baseTimeUnit = TimeUnit.MILLISECONDS;
    private boolean prometheusMode = false;

    OpenTelemetryMeterRegistryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public OpenTelemetryMeterRegistryBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public OpenTelemetryMeterRegistryBuilder setBaseTimeUnit(TimeUnit baseTimeUnit) {
        this.baseTimeUnit = baseTimeUnit;
        return this;
    }

    public OpenTelemetryMeterRegistryBuilder setPrometheusMode(boolean prometheusMode) {
        this.prometheusMode = prometheusMode;
        return this;
    }

    public MeterRegistry build() {
        TimeUnit baseTimeUnit = this.prometheusMode ? TimeUnit.SECONDS : this.baseTimeUnit;
        PrometheusModeNamingConvention namingConvention = this.prometheusMode ? PrometheusModeNamingConvention.INSTANCE : NamingConvention.identity;
        return new OpenTelemetryMeterRegistry(this.clock, baseTimeUnit, namingConvention, this.openTelemetry.getMeterProvider().get(INSTRUMENTATION_NAME));
    }
}

