/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.micrometer1shim;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.micrometer1shim.Bridging;
import io.opentelemetry.micrometer1shim.RemovableMeter;
import io.opentelemetry.micrometer1shim.UnsupportedReadLogger;
import java.util.Collections;
import javax.annotation.Nullable;

final class OpenTelemetryCounter
implements Counter,
RemovableMeter {
    private final Meter.Id id;
    private final DoubleCounter otelCounter;
    private final Attributes attributes;
    private volatile boolean removed = false;

    OpenTelemetryCounter(Meter.Id id, NamingConvention namingConvention, io.opentelemetry.api.metrics.Meter otelMeter) {
        this.id = id;
        this.attributes = Bridging.tagsAsAttributes(id, namingConvention);
        String conventionName = Bridging.name(id, namingConvention);
        this.otelCounter = otelMeter.counterBuilder(conventionName).setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).ofDoubles().build();
    }

    public void increment(double v) {
        if (this.removed) {
            return;
        }
        this.otelCounter.add(v, this.attributes);
    }

    public double count() {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    public Meter.Id getId() {
        return this.id;
    }

    @Override
    public void onRemove() {
        this.removed = true;
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

