/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.micrometer1shim;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.micrometer1shim.Bridging;
import io.opentelemetry.micrometer1shim.DoubleMeasurementRecorder;
import io.opentelemetry.micrometer1shim.RemovableMeter;
import io.opentelemetry.micrometer1shim.UnsupportedReadLogger;
import java.util.Collections;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;

final class OpenTelemetryGauge<T>
implements Gauge,
RemovableMeter {
    private final Meter.Id id;
    private final ObservableDoubleGauge observableGauge;

    OpenTelemetryGauge(Meter.Id id, NamingConvention namingConvention, @Nullable T obj, ToDoubleFunction<T> objMetric, io.opentelemetry.api.metrics.Meter otelMeter) {
        this.id = id;
        String name = Bridging.name(id, namingConvention);
        this.observableGauge = otelMeter.gaugeBuilder(name).setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).buildWithCallback(new DoubleMeasurementRecorder<T>(obj, objMetric, Bridging.tagsAsAttributes(id, namingConvention)));
    }

    public double value() {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    public Meter.Id getId() {
        return this.id;
    }

    @Override
    public void onRemove() {
        this.observableGauge.close();
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

