/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.micrometer1shim;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.micrometer1shim.Bridging;
import io.opentelemetry.micrometer1shim.DoubleMeasurementRecorder;
import io.opentelemetry.micrometer1shim.RemovableMeter;
import io.opentelemetry.micrometer1shim.UnsupportedReadLogger;
import java.util.Collections;
import java.util.function.ToDoubleFunction;

final class OpenTelemetryFunctionCounter<T>
extends AbstractMeter
implements FunctionCounter,
RemovableMeter {
    private final ObservableDoubleCounter observableCount;

    OpenTelemetryFunctionCounter(Meter.Id id, NamingConvention namingConvention, T obj, ToDoubleFunction<T> countFunction, Meter otelMeter) {
        super(id);
        String name = Bridging.name(id, namingConvention);
        this.observableCount = otelMeter.counterBuilder(name).ofDoubles().setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).buildWithCallback(new DoubleMeasurementRecorder<T>(obj, countFunction, Bridging.tagsAsAttributes(id, namingConvention)));
    }

    public double count() {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.observableCount.close();
    }
}

