/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.micrometer1shim;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.TimeUtils;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleCounter;
import io.opentelemetry.api.metrics.ObservableLongCounter;
import io.opentelemetry.micrometer1shim.Bridging;
import io.opentelemetry.micrometer1shim.DoubleMeasurementRecorder;
import io.opentelemetry.micrometer1shim.LongMeasurementRecorder;
import io.opentelemetry.micrometer1shim.RemovableMeter;
import io.opentelemetry.micrometer1shim.TimeUnitHelper;
import io.opentelemetry.micrometer1shim.UnsupportedReadLogger;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

final class OpenTelemetryFunctionTimer<T>
extends AbstractMeter
implements FunctionTimer,
RemovableMeter {
    private final TimeUnit baseTimeUnit;
    private final ObservableLongCounter observableCount;
    private final ObservableDoubleCounter observableTotalTime;

    OpenTelemetryFunctionTimer(Meter.Id id, NamingConvention namingConvention, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit, TimeUnit baseTimeUnit, Meter otelMeter) {
        super(id);
        this.baseTimeUnit = baseTimeUnit;
        String name = Bridging.name(id, namingConvention);
        Attributes attributes = Bridging.tagsAsAttributes(id, namingConvention);
        this.observableCount = otelMeter.counterBuilder(name + ".count").setDescription(Bridging.description(id)).setUnit("1").buildWithCallback(new LongMeasurementRecorder<T>(obj, countFunction, attributes));
        this.observableTotalTime = otelMeter.counterBuilder(name + ".sum").ofDoubles().setDescription(Bridging.description(id)).setUnit(TimeUnitHelper.getUnitString(baseTimeUnit)).buildWithCallback(new DoubleMeasurementRecorder<Object>(obj, val -> TimeUtils.convert((double)totalTimeFunction.applyAsDouble(val), (TimeUnit)totalTimeFunctionUnit, (TimeUnit)baseTimeUnit), attributes));
    }

    public double count() {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public double totalTime(TimeUnit unit) {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public double mean(TimeUnit unit) {
        UnsupportedReadLogger.logWarning();
        return Double.NaN;
    }

    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.observableCount.close();
        this.observableTotalTime.close();
    }
}

