/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import com.google.common.base.Joiner;
import io.opencensus.common.Duration;
import io.opencensus.exporter.metrics.util.IntervalMetricReader;
import io.opencensus.exporter.metrics.util.MetricExporter;
import io.opencensus.exporter.metrics.util.MetricReader;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.Summary;
import io.opencensus.metrics.export.TimeSeries;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.api.metrics.common.LabelsBuilder;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.LongGaugeData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class OpenTelemetryMetricsExporter
extends MetricExporter {
    private static final Logger LOGGER = Logger.getLogger(OpenTelemetryMetricsExporter.class.getName());
    private static final String EXPORTER_NAME = "OpenTelemetryMetricExporter";
    private static final InstrumentationLibraryInfo INSTRUMENTATION_LIBRARY_INFO = InstrumentationLibraryInfo.create((String)"io.opentelemetry.opencensusshim", null);
    private final IntervalMetricReader intervalMetricReader;
    private final io.opentelemetry.sdk.metrics.export.MetricExporter otelExporter;

    public static OpenTelemetryMetricsExporter createAndRegister(io.opentelemetry.sdk.metrics.export.MetricExporter otelExporter) {
        return new OpenTelemetryMetricsExporter(otelExporter, Duration.create((long)60L, (int)0));
    }

    public static OpenTelemetryMetricsExporter createAndRegister(io.opentelemetry.sdk.metrics.export.MetricExporter otelExporter, Duration exportInterval) {
        return new OpenTelemetryMetricsExporter(otelExporter, exportInterval);
    }

    private OpenTelemetryMetricsExporter(io.opentelemetry.sdk.metrics.export.MetricExporter otelExporter, Duration exportInterval) {
        this.otelExporter = otelExporter;
        IntervalMetricReader.Options.Builder options = IntervalMetricReader.Options.builder();
        MetricReader reader = MetricReader.create((MetricReader.Options)MetricReader.Options.builder().setMetricProducerManager(Metrics.getExportComponent().getMetricProducerManager()).setSpanName(EXPORTER_NAME).build());
        this.intervalMetricReader = IntervalMetricReader.create((MetricExporter)this, (MetricReader)reader, (IntervalMetricReader.Options)options.setExportInterval(exportInterval).build());
    }

    public void export(Collection<Metric> metrics) {
        ArrayList<MetricData> metricData = new ArrayList<MetricData>();
        HashSet<MetricDescriptor.Type> unsupportedTypes = new HashSet<MetricDescriptor.Type>();
        for (Metric metric : metrics) {
            for (TimeSeries timeSeries : metric.getTimeSeriesList()) {
                LabelsBuilder labelsBuilder = Labels.builder();
                for (int i = 0; i < metric.getMetricDescriptor().getLabelKeys().size(); ++i) {
                    if (((LabelValue)timeSeries.getLabelValues().get(i)).getValue() == null) continue;
                    labelsBuilder.put(((LabelKey)metric.getMetricDescriptor().getLabelKeys().get(i)).getKey(), ((LabelValue)timeSeries.getLabelValues().get(i)).getValue());
                }
                Labels labels = labelsBuilder.build();
                ArrayList<PointData> points = new ArrayList<PointData>();
                MetricDescriptor.Type type = null;
                for (Point point : timeSeries.getPoints()) {
                    type = OpenTelemetryMetricsExporter.mapAndAddPoint(unsupportedTypes, metric, labels, points, point);
                }
                MetricData md = OpenTelemetryMetricsExporter.toMetricData(type, metric.getMetricDescriptor(), points);
                if (md == null) continue;
                metricData.add(md);
            }
        }
        if (!unsupportedTypes.isEmpty()) {
            LOGGER.warning(Joiner.on((String)",").join(unsupportedTypes) + " not supported by OpenCensus to OpenTelemetry migrator.");
        }
        if (!metricData.isEmpty()) {
            this.otelExporter.export(metricData);
        }
    }

    @Nonnull
    private static MetricDescriptor.Type mapAndAddPoint(Set<MetricDescriptor.Type> unsupportedTypes, Metric metric, Labels labels, List<PointData> points, Point point) {
        long timestampNanos = TimeUnit.SECONDS.toNanos(point.getTimestamp().getSeconds()) + (long)point.getTimestamp().getNanos();
        MetricDescriptor.Type type = metric.getMetricDescriptor().getType();
        switch (type) {
            case GAUGE_INT64: 
            case CUMULATIVE_INT64: {
                points.add((PointData)OpenTelemetryMetricsExporter.mapLongPoint(labels, point, timestampNanos));
                break;
            }
            case GAUGE_DOUBLE: 
            case CUMULATIVE_DOUBLE: {
                points.add((PointData)OpenTelemetryMetricsExporter.mapDoublePoint(labels, point, timestampNanos));
                break;
            }
            case SUMMARY: {
                points.add((PointData)OpenTelemetryMetricsExporter.mapSummaryPoint(labels, point, timestampNanos));
                break;
            }
            default: {
                unsupportedTypes.add(type);
            }
        }
        return type;
    }

    public void stop() {
        this.intervalMetricReader.stop();
    }

    @Nonnull
    private static DoubleSummaryPointData mapSummaryPoint(Labels labels, Point point, long timestampNanos) {
        return DoubleSummaryPointData.create((long)timestampNanos, (long)timestampNanos, (Labels)labels, (long)((Long)point.getValue().match(arg -> null, arg -> null, arg -> null, Summary::getCount, arg -> null)), (double)((Double)point.getValue().match(arg -> null, arg -> null, arg -> null, Summary::getSum, arg -> null)), (List)((List)point.getValue().match(arg -> null, arg -> null, arg -> null, OpenTelemetryMetricsExporter::mapPercentiles, arg -> null)));
    }

    private static List<ValueAtPercentile> mapPercentiles(Summary arg) {
        ArrayList<ValueAtPercentile> percentiles = new ArrayList<ValueAtPercentile>();
        for (Summary.Snapshot.ValueAtPercentile percentile : arg.getSnapshot().getValueAtPercentiles()) {
            percentiles.add(ValueAtPercentile.create((double)percentile.getPercentile(), (double)percentile.getValue()));
        }
        return percentiles;
    }

    @Nonnull
    private static DoublePointData mapDoublePoint(Labels labels, Point point, long timestampNanos) {
        return DoublePointData.create((long)timestampNanos, (long)timestampNanos, (Labels)labels, (double)((Double)point.getValue().match(arg -> arg, Long::doubleValue, arg -> null, arg -> null, arg -> null)));
    }

    @Nonnull
    private static LongPointData mapLongPoint(Labels labels, Point point, long timestampNanos) {
        return LongPointData.create((long)timestampNanos, (long)timestampNanos, (Labels)labels, (long)((Long)point.getValue().match(Double::longValue, arg -> arg, arg -> null, arg -> null, arg -> null)));
    }

    @Nullable
    private static MetricData toMetricData(MetricDescriptor.Type type, MetricDescriptor metricDescriptor, List<? extends PointData> points) {
        if (metricDescriptor.getType() == null) {
            return null;
        }
        switch (type) {
            case GAUGE_INT64: {
                return MetricData.createLongGauge((Resource)Resource.getDefault(), (InstrumentationLibraryInfo)INSTRUMENTATION_LIBRARY_INFO, (String)metricDescriptor.getName(), (String)metricDescriptor.getDescription(), (String)metricDescriptor.getUnit(), (LongGaugeData)LongGaugeData.create(points));
            }
            case GAUGE_DOUBLE: {
                return MetricData.createDoubleGauge((Resource)Resource.getDefault(), (InstrumentationLibraryInfo)INSTRUMENTATION_LIBRARY_INFO, (String)metricDescriptor.getName(), (String)metricDescriptor.getDescription(), (String)metricDescriptor.getUnit(), (DoubleGaugeData)DoubleGaugeData.create(points));
            }
            case CUMULATIVE_INT64: {
                return MetricData.createLongSum((Resource)Resource.getDefault(), (InstrumentationLibraryInfo)INSTRUMENTATION_LIBRARY_INFO, (String)metricDescriptor.getName(), (String)metricDescriptor.getDescription(), (String)metricDescriptor.getUnit(), (LongSumData)LongSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, points));
            }
            case CUMULATIVE_DOUBLE: {
                return MetricData.createDoubleSum((Resource)Resource.getDefault(), (InstrumentationLibraryInfo)INSTRUMENTATION_LIBRARY_INFO, (String)metricDescriptor.getName(), (String)metricDescriptor.getDescription(), (String)metricDescriptor.getUnit(), (DoubleSumData)DoubleSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, points));
            }
            case SUMMARY: {
                return MetricData.createDoubleSummary((Resource)Resource.getDefault(), (InstrumentationLibraryInfo)INSTRUMENTATION_LIBRARY_INFO, (String)metricDescriptor.getName(), (String)metricDescriptor.getDescription(), (String)metricDescriptor.getUnit(), (DoubleSummaryData)DoubleSummaryData.create(points));
            }
        }
        return null;
    }
}

