/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import io.opencensus.trace.propagation.TextFormat;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.opencensusshim.SpanConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class OpenTelemetryTextFormatImpl
extends TextFormat {
    private final TextMapPropagator propagator;

    OpenTelemetryTextFormatImpl(TextMapPropagator propagator) {
        this.propagator = propagator;
    }

    public List<String> fields() {
        return new ArrayList<String>(this.propagator.fields());
    }

    public <C> void inject(io.opencensus.trace.SpanContext spanContext, C carrier, TextFormat.Setter<C> setter) {
        SpanContext otelSpanContext = SpanConverter.mapSpanContext(spanContext);
        Context otelContext = Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)otelSpanContext));
        this.propagator.inject(otelContext, carrier, (arg_0, arg_1, arg_2) -> setter.put(arg_0, arg_1, arg_2));
    }

    public <C> io.opencensus.trace.SpanContext extract(C carrier, final TextFormat.Getter<C> getter) {
        Context context = this.propagator.extract(Context.current(), carrier, new TextMapGetter<C>(){

            public Iterable<String> keys(C carrier) {
                return Collections.emptyList();
            }

            @Nullable
            public String get(@Nullable C carrier, String key) {
                return getter.get(carrier, key);
            }
        });
        SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
        return SpanConverter.mapSpanContext(spanContext);
    }
}

