/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim.internal.metrics;

import io.opencensus.common.Timestamp;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.data.AttachmentValue;
import io.opencensus.metrics.data.Exemplar;
import io.opencensus.metrics.export.Distribution;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.Summary;
import io.opencensus.metrics.export.TimeSeries;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoubleExemplarData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableValueAtQuantile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MetricAdapter {
    static final InstrumentationScopeInfo INSTRUMENTATION_SCOPE_INFO = InstrumentationScopeInfo.create((String)"io.opentelemetry.opencensusshim");
    private static final Pattern OPENCENSUS_TRACE_ATTACHMENT_PATTERN = Pattern.compile("SpanContext\\{traceId=TraceId\\{traceId=([0-9A-Ga-g]+)\\}, spanId=SpanId\\{spanId=([0-9A-Ga-g]+)\\},.*\\}");

    private MetricAdapter() {
    }

    public static MetricData convert(Resource otelResource, Metric censusMetric) {
        switch (censusMetric.getMetricDescriptor().getType()) {
            case GAUGE_INT64: {
                return ImmutableMetricData.createLongGauge((Resource)otelResource, (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)censusMetric.getMetricDescriptor().getName(), (String)censusMetric.getMetricDescriptor().getDescription(), (String)censusMetric.getMetricDescriptor().getUnit(), MetricAdapter.convertLongGauge(censusMetric));
            }
            case GAUGE_DOUBLE: {
                return ImmutableMetricData.createDoubleGauge((Resource)otelResource, (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)censusMetric.getMetricDescriptor().getName(), (String)censusMetric.getMetricDescriptor().getDescription(), (String)censusMetric.getMetricDescriptor().getUnit(), MetricAdapter.convertDoubleGauge(censusMetric));
            }
            case CUMULATIVE_INT64: {
                return ImmutableMetricData.createLongSum((Resource)otelResource, (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)censusMetric.getMetricDescriptor().getName(), (String)censusMetric.getMetricDescriptor().getDescription(), (String)censusMetric.getMetricDescriptor().getUnit(), MetricAdapter.convertLongSum(censusMetric));
            }
            case CUMULATIVE_DOUBLE: {
                return ImmutableMetricData.createDoubleSum((Resource)otelResource, (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)censusMetric.getMetricDescriptor().getName(), (String)censusMetric.getMetricDescriptor().getDescription(), (String)censusMetric.getMetricDescriptor().getUnit(), MetricAdapter.convertDoubleSum(censusMetric));
            }
            case CUMULATIVE_DISTRIBUTION: {
                return ImmutableMetricData.createDoubleHistogram((Resource)otelResource, (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)censusMetric.getMetricDescriptor().getName(), (String)censusMetric.getMetricDescriptor().getDescription(), (String)censusMetric.getMetricDescriptor().getUnit(), (HistogramData)MetricAdapter.convertHistogram(censusMetric));
            }
            case SUMMARY: {
                return ImmutableMetricData.createDoubleSummary((Resource)otelResource, (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)censusMetric.getMetricDescriptor().getName(), (String)censusMetric.getMetricDescriptor().getDescription(), (String)censusMetric.getMetricDescriptor().getUnit(), (SummaryData)MetricAdapter.convertSummary(censusMetric));
            }
            case GAUGE_DISTRIBUTION: {
                return ImmutableMetricData.createDoubleHistogram((Resource)otelResource, (InstrumentationScopeInfo)INSTRUMENTATION_SCOPE_INFO, (String)censusMetric.getMetricDescriptor().getName(), (String)censusMetric.getMetricDescriptor().getDescription(), (String)censusMetric.getMetricDescriptor().getUnit(), (HistogramData)MetricAdapter.convertGaugeHistogram(censusMetric));
            }
        }
        throw new IllegalArgumentException("Unknown OpenCensus metric type: " + censusMetric.getMetricDescriptor().getType());
    }

    static GaugeData<LongPointData> convertLongGauge(Metric censusMetric) {
        return ImmutableGaugeData.create(MetricAdapter.convertLongPoints(censusMetric));
    }

    static GaugeData<DoublePointData> convertDoubleGauge(Metric censusMetric) {
        return ImmutableGaugeData.create(MetricAdapter.convertDoublePoints(censusMetric));
    }

    static SumData<LongPointData> convertLongSum(Metric censusMetric) {
        return ImmutableSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, MetricAdapter.convertLongPoints(censusMetric));
    }

    static SumData<DoublePointData> convertDoubleSum(Metric censusMetric) {
        return ImmutableSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, MetricAdapter.convertDoublePoints(censusMetric));
    }

    static HistogramData convertHistogram(Metric censusMetric) {
        return ImmutableHistogramData.create((AggregationTemporality)AggregationTemporality.CUMULATIVE, MetricAdapter.convertHistogramPoints(censusMetric));
    }

    static HistogramData convertGaugeHistogram(Metric censusMetric) {
        return ImmutableHistogramData.create((AggregationTemporality)AggregationTemporality.DELTA, MetricAdapter.convertHistogramPoints(censusMetric));
    }

    static SummaryData convertSummary(Metric censusMetric) {
        return ImmutableSummaryData.create(MetricAdapter.convertSummaryPoints(censusMetric));
    }

    static Collection<LongPointData> convertLongPoints(Metric censusMetric) {
        ArrayList<LongPointData> result = new ArrayList<LongPointData>();
        for (TimeSeries ts : censusMetric.getTimeSeriesList()) {
            long startTimestamp = MetricAdapter.mapTimestamp(ts.getStartTimestamp());
            Attributes attributes = MetricAdapter.mapAttributes(censusMetric.getMetricDescriptor().getLabelKeys(), ts.getLabelValues());
            for (Point point : ts.getPoints()) {
                result.add(ImmutableLongPointData.create((long)startTimestamp, (long)MetricAdapter.mapTimestamp(point.getTimestamp()), (Attributes)attributes, (long)MetricAdapter.longValue(point)));
            }
        }
        return result;
    }

    static Collection<DoublePointData> convertDoublePoints(Metric censusMetric) {
        ArrayList<DoublePointData> result = new ArrayList<DoublePointData>();
        for (TimeSeries ts : censusMetric.getTimeSeriesList()) {
            long startTimestamp = MetricAdapter.mapTimestamp(ts.getStartTimestamp());
            Attributes attributes = MetricAdapter.mapAttributes(censusMetric.getMetricDescriptor().getLabelKeys(), ts.getLabelValues());
            for (Point point : ts.getPoints()) {
                result.add(ImmutableDoublePointData.create((long)startTimestamp, (long)MetricAdapter.mapTimestamp(point.getTimestamp()), (Attributes)attributes, (double)MetricAdapter.doubleValue(point)));
            }
        }
        return result;
    }

    static Collection<HistogramPointData> convertHistogramPoints(Metric censusMetric) {
        boolean isGauge = censusMetric.getMetricDescriptor().getType() == MetricDescriptor.Type.GAUGE_DISTRIBUTION;
        ArrayList<HistogramPointData> result = new ArrayList<HistogramPointData>();
        for (TimeSeries ts : censusMetric.getTimeSeriesList()) {
            long startTimestamp = MetricAdapter.mapTimestamp(ts.getStartTimestamp());
            Attributes attributes = MetricAdapter.mapAttributes(censusMetric.getMetricDescriptor().getLabelKeys(), ts.getLabelValues());
            for (Point point : ts.getPoints()) {
                long endTimestamp = MetricAdapter.mapTimestamp(point.getTimestamp());
                HistogramPointData otelPoint = (HistogramPointData)point.getValue().match(doubleValue -> null, longValue -> null, distribution -> ImmutableHistogramPointData.create((long)(isGauge ? endTimestamp : startTimestamp), (long)endTimestamp, (Attributes)attributes, (double)distribution.getSum(), null, null, MetricAdapter.mapBoundaries(distribution.getBucketOptions()), MetricAdapter.mapCounts(distribution.getBuckets()), MetricAdapter.mapExemplars(distribution.getBuckets())), summary -> null, defaultValue -> null);
                if (otelPoint == null) continue;
                result.add(otelPoint);
            }
        }
        return result;
    }

    static Collection<SummaryPointData> convertSummaryPoints(Metric censusMetric) {
        ArrayList<SummaryPointData> result = new ArrayList<SummaryPointData>();
        for (TimeSeries ts : censusMetric.getTimeSeriesList()) {
            long startTimestamp = MetricAdapter.mapTimestamp(ts.getStartTimestamp());
            Attributes attributes = MetricAdapter.mapAttributes(censusMetric.getMetricDescriptor().getLabelKeys(), ts.getLabelValues());
            for (Point point : ts.getPoints()) {
                SummaryPointData otelPoint = (SummaryPointData)point.getValue().match(dv -> null, lv -> null, distribution -> null, summary -> ImmutableSummaryPointData.create((long)startTimestamp, (long)MetricAdapter.mapTimestamp(point.getTimestamp()), (Attributes)attributes, (long)summary.getCount(), (double)summary.getSum(), MetricAdapter.mapValueAtPercentiles(summary.getSnapshot().getValueAtPercentiles())), defaultValue -> null);
                if (otelPoint == null) continue;
                result.add(otelPoint);
            }
        }
        return result;
    }

    static Attributes mapAttributes(List<LabelKey> labels, List<LabelValue> values) {
        AttributesBuilder result = Attributes.builder();
        for (int i = 0; i < labels.size(); ++i) {
            result.put(labels.get(i).getKey(), values.get(i).getValue());
        }
        return result.build();
    }

    static long longValue(Point point) {
        return ((Number)point.getValue().match(Double::longValue, lv -> lv, distribution -> 0, summary -> 0, defaultValue -> 0)).longValue();
    }

    static double doubleValue(Point point) {
        return ((Number)point.getValue().match(d -> d, Long::doubleValue, distribution -> 0, summary -> 0, defaultValue -> 0)).doubleValue();
    }

    static List<Double> mapBoundaries(Distribution.BucketOptions censusBuckets) {
        return (List)censusBuckets.match(explicit -> explicit.getBucketBoundaries(), defaultOption -> Collections.emptyList());
    }

    static List<Long> mapCounts(List<Distribution.Bucket> buckets) {
        ArrayList<Long> result = new ArrayList<Long>(buckets.size());
        for (Distribution.Bucket bucket : buckets) {
            result.add(bucket.getCount());
        }
        return result;
    }

    static List<ExemplarData> mapExemplars(List<Distribution.Bucket> buckets) {
        ArrayList<ExemplarData> result = new ArrayList<ExemplarData>();
        for (Distribution.Bucket bucket : buckets) {
            Exemplar exemplar = bucket.getExemplar();
            if (exemplar == null) continue;
            result.add(MetricAdapter.mapExemplar(exemplar));
        }
        return result;
    }

    private static ExemplarData mapExemplar(Exemplar exemplar) {
        String spanContextToString;
        Matcher m;
        SpanContext spanContext = SpanContext.getInvalid();
        if (exemplar.getAttachments().containsKey("SpanContext") && (m = OPENCENSUS_TRACE_ATTACHMENT_PATTERN.matcher(spanContextToString = ((AttachmentValue)exemplar.getAttachments().get("SpanContext")).getValue())).matches()) {
            MatchResult mr = m.toMatchResult();
            String traceId = mr.group(1);
            String spanId = mr.group(2);
            spanContext = SpanContext.create((String)traceId, (String)spanId, (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault());
        }
        return ImmutableDoubleExemplarData.create((Attributes)Attributes.empty(), (long)MetricAdapter.mapTimestamp(exemplar.getTimestamp()), (SpanContext)spanContext, (double)exemplar.getValue());
    }

    static long mapTimestamp(@Nullable Timestamp time) {
        if (time == null) {
            return 0L;
        }
        return TimeUnit.SECONDS.toNanos(time.getSeconds()) + (long)time.getNanos();
    }

    private static List<ValueAtQuantile> mapValueAtPercentiles(List<Summary.Snapshot.ValueAtPercentile> valueAtPercentiles) {
        ArrayList<ValueAtQuantile> result = new ArrayList<ValueAtQuantile>(valueAtPercentiles.size());
        for (Summary.Snapshot.ValueAtPercentile censusValue : valueAtPercentiles) {
            result.add(ImmutableValueAtQuantile.create((double)(censusValue.getPercentile() / 100.0), (double)censusValue.getValue()));
        }
        return result;
    }
}

