/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim.metrics;

import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.MetricProducerManager;
import io.opentelemetry.opencensusshim.internal.metrics.MetricAdapter;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.export.MetricProducer;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;

final class OpenCensusMetricProducer
implements MetricProducer {
    private final Resource resource;
    private final MetricProducerManager openCensusMetricStorage;

    OpenCensusMetricProducer(Resource resource, MetricProducerManager openCensusMetricStorage) {
        this.resource = resource;
        this.openCensusMetricStorage = openCensusMetricStorage;
    }

    static MetricProducer create(Resource resource) {
        return new OpenCensusMetricProducer(resource, Metrics.getExportComponent().getMetricProducerManager());
    }

    public Collection<MetricData> collectAllMetrics() {
        ArrayList<MetricData> result = new ArrayList<MetricData>();
        this.openCensusMetricStorage.getAllMetricProducer().forEach(producer -> producer.getMetrics().forEach(metric -> result.add(MetricAdapter.convert(this.resource, metric))));
        return result;
    }
}

