/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opencensusshim;

import com.google.common.base.Preconditions;
import io.opencensus.implcore.trace.internal.RandomHandler;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracestate;
import io.opencensus.trace.config.TraceConfig;
import io.opencensus.trace.config.TraceParams;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.opencensusshim.OpenTelemetryNoRecordEventsSpanImpl;
import io.opentelemetry.opencensusshim.OpenTelemetrySpanImpl;
import io.opentelemetry.opencensusshim.SpanConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

final class OpenTelemetrySpanBuilderImpl
extends SpanBuilder {
    private static final Tracer OTEL_TRACER = GlobalOpenTelemetry.getTracer((String)"io.opentelemetry.opencensusshim", (String)"1.51.0");
    private static final Tracestate OC_TRACESTATE_DEFAULT = Tracestate.builder().build();
    private static final TraceOptions OC_SAMPLED_TRACE_OPTIONS = TraceOptions.builder().setIsSampled(true).build();
    private static final TraceOptions OC_NOT_SAMPLED_TRACE_OPTIONS = TraceOptions.builder().setIsSampled(false).build();
    private final String name;
    private final Options options;
    private List<io.opencensus.trace.Span> ocParentLinks = Collections.emptyList();
    private final List<SpanContext> otelParentLinks = new ArrayList<SpanContext>();
    @Nullable
    private final io.opencensus.trace.Span ocParent;
    @Nullable
    private final io.opencensus.trace.SpanContext ocRemoteParentSpanContext;
    @Nullable
    private Sampler ocSampler;
    @Nullable
    private SpanKind otelKind;

    private OpenTelemetrySpanBuilderImpl(String name, @Nullable io.opencensus.trace.SpanContext ocRemoteParentSpanContext, @Nullable io.opencensus.trace.Span ocParent, Options options) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.ocParent = ocParent;
        this.ocRemoteParentSpanContext = ocRemoteParentSpanContext;
        this.options = options;
    }

    static OpenTelemetrySpanBuilderImpl createWithParent(String spanName, @Nullable io.opencensus.trace.Span parent, Options options) {
        return new OpenTelemetrySpanBuilderImpl(spanName, null, parent, options);
    }

    static OpenTelemetrySpanBuilderImpl createWithRemoteParent(String spanName, @Nullable io.opencensus.trace.SpanContext remoteParentSpanContext, Options options) {
        return new OpenTelemetrySpanBuilderImpl(spanName, remoteParentSpanContext, null, options);
    }

    public SpanBuilder setSampler(Sampler sampler) {
        this.ocSampler = (Sampler)Preconditions.checkNotNull((Object)sampler, (Object)"sampler");
        return this;
    }

    public SpanBuilder setParentLinks(List<io.opencensus.trace.Span> parentLinks) {
        this.ocParentLinks = (List)Preconditions.checkNotNull(parentLinks, (Object)"parentLinks");
        for (io.opencensus.trace.Span parent : parentLinks) {
            this.otelParentLinks.add(SpanConverter.mapSpanContext(parent.getContext()));
        }
        return this;
    }

    public SpanBuilder setRecordEvents(boolean recordEvents) {
        return this;
    }

    public SpanBuilder setSpanKind(@Nullable Span.Kind kind) {
        this.otelKind = SpanConverter.mapKind(kind);
        return this;
    }

    public io.opencensus.trace.Span startSpan() {
        TraceOptions ocTraceOptions;
        TraceId ocTraceId;
        TraceParams ocActiveTraceParams = this.options.traceConfig.getActiveTraceParams();
        Random random = this.options.randomHandler.current();
        SpanId ocSpanId = SpanId.generateRandomId((Random)random);
        Tracestate ocTracestate = OC_TRACESTATE_DEFAULT;
        io.opencensus.trace.SpanContext ocParentContext = null;
        Boolean hasRemoteParent = null;
        if (this.ocRemoteParentSpanContext != null && this.ocRemoteParentSpanContext.isValid()) {
            ocParentContext = this.ocRemoteParentSpanContext;
            hasRemoteParent = Boolean.TRUE;
            ocTraceId = ocParentContext.getTraceId();
            ocTracestate = ocParentContext.getTracestate();
        } else if (this.ocParent != null && this.ocParent.getContext().isValid()) {
            ocParentContext = this.ocParent.getContext();
            hasRemoteParent = Boolean.FALSE;
            ocTraceId = ocParentContext.getTraceId();
            ocTracestate = ocParentContext.getTracestate();
        } else {
            ocTraceId = TraceId.generateRandomId((Random)random);
        }
        TraceOptions traceOptions = ocTraceOptions = OpenTelemetrySpanBuilderImpl.makeSamplingDecision(ocParentContext, hasRemoteParent, this.name, this.ocSampler, this.ocParentLinks, ocTraceId, ocSpanId, ocActiveTraceParams) ? OC_SAMPLED_TRACE_OPTIONS : OC_NOT_SAMPLED_TRACE_OPTIONS;
        if (!ocTraceOptions.isSampled()) {
            return OpenTelemetryNoRecordEventsSpanImpl.create(io.opencensus.trace.SpanContext.create((TraceId)ocTraceId, (SpanId)ocSpanId, (TraceOptions)ocTraceOptions, (Tracestate)ocTracestate));
        }
        io.opentelemetry.api.trace.SpanBuilder otelSpanBuilder = OTEL_TRACER.spanBuilder(this.name);
        if (this.ocParent != null && this.ocParent instanceof OpenTelemetrySpanImpl) {
            otelSpanBuilder.setParent(Context.current().with((ImplicitContextKeyed)((OpenTelemetrySpanImpl)this.ocParent)));
        }
        if (this.ocRemoteParentSpanContext != null) {
            SpanContext spanContext = SpanConverter.mapSpanContext(this.ocRemoteParentSpanContext, true);
            otelSpanBuilder.setParent(Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext)));
            otelSpanBuilder.addLink(spanContext);
        }
        if (this.otelKind != null) {
            otelSpanBuilder.setSpanKind(this.otelKind);
        }
        if (!this.otelParentLinks.isEmpty()) {
            for (SpanContext spanContext : this.otelParentLinks) {
                otelSpanBuilder.addLink(spanContext);
            }
        }
        Span otSpan = otelSpanBuilder.startSpan();
        return new OpenTelemetrySpanImpl(otSpan);
    }

    private static boolean makeSamplingDecision(@Nullable io.opencensus.trace.SpanContext parent, @Nullable Boolean hasRemoteParent, String name, @Nullable Sampler sampler, List<io.opencensus.trace.Span> parentLinks, TraceId traceId, SpanId spanId, TraceParams activeTraceParams) {
        if (sampler != null) {
            return sampler.shouldSample(parent, hasRemoteParent, traceId, spanId, name, parentLinks);
        }
        if (Boolean.TRUE.equals(hasRemoteParent) || parent == null || !parent.isValid()) {
            return activeTraceParams.getSampler().shouldSample(parent, hasRemoteParent, traceId, spanId, name, parentLinks);
        }
        return parent.getTraceOptions().isSampled() || OpenTelemetrySpanBuilderImpl.isAnyParentLinkSampled(parentLinks);
    }

    private static boolean isAnyParentLinkSampled(List<io.opencensus.trace.Span> parentLinks) {
        for (io.opencensus.trace.Span parentLink : parentLinks) {
            if (!parentLink.getContext().getTraceOptions().isSampled()) continue;
            return true;
        }
        return false;
    }

    static final class Options {
        private final RandomHandler randomHandler;
        private final TraceConfig traceConfig;

        Options(RandomHandler randomHandler, TraceConfig traceConfig) {
            this.randomHandler = (RandomHandler)Preconditions.checkNotNull((Object)randomHandler, (Object)"randomHandler");
            this.traceConfig = (TraceConfig)Preconditions.checkNotNull((Object)traceConfig, (Object)"traceConfig");
        }
    }
}

