/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.SpanShim;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;

final class SpanContextShimTable {
    private final Map<Span, SpanContextShim> shimsMap = new WeakHashMap<Span, SpanContextShim>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    SpanContextShimTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaggageItem(SpanShim spanShim, String key, String value) {
        this.lock.writeLock().lock();
        try {
            SpanContextShim contextShim = this.shimsMap.get(spanShim.getSpan());
            if (contextShim == null) {
                contextShim = new SpanContextShim(spanShim);
            }
            contextShim = contextShim.newWithKeyValue(key, value);
            this.shimsMap.put(spanShim.getSpan(), contextShim);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getBaggageItem(SpanShim spanShim, String key) {
        this.lock.readLock().lock();
        try {
            SpanContextShim contextShim = this.shimsMap.get(spanShim.getSpan());
            String string = contextShim == null ? null : contextShim.getBaggageItem(key);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nullable
    public SpanContextShim get(SpanShim spanShim) {
        this.lock.readLock().lock();
        try {
            SpanContextShim spanContextShim = this.shimsMap.get(spanShim.getSpan());
            return spanContextShim;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public SpanContextShim create(SpanShim spanShim) {
        return this.create(spanShim, spanShim.telemetryInfo().emptyBaggage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanContextShim create(SpanShim spanShim, Baggage baggage) {
        this.lock.writeLock().lock();
        try {
            SpanContextShim contextShim = this.shimsMap.get(spanShim.getSpan());
            if (contextShim != null) {
                SpanContextShim spanContextShim = contextShim;
                return spanContextShim;
            }
            contextShim = new SpanContextShim(spanShim.telemetryInfo(), spanShim.getSpan().getSpanContext(), baggage);
            this.shimsMap.put(spanShim.getSpan(), contextShim);
            SpanContextShim spanContextShim = contextShim;
            return spanContextShim;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

