/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class ShimUtil {
    private ShimUtil() {
    }

    static SpanContextShim getContextShim(SpanContext context) {
        if (!(context instanceof SpanContextShim)) {
            throw new IllegalArgumentException("context is not a valid SpanContextShim object: " + ShimUtil.className(context));
        }
        return (SpanContextShim)context;
    }

    static SpanShim getSpanShim(Span span) {
        if (!(span instanceof SpanShim)) {
            if (span instanceof Supplier) {
                Object wrapped = ((Supplier)span).get();
                if (wrapped instanceof Span) {
                    return ShimUtil.getSpanShim((Span)wrapped);
                }
                throw new IllegalArgumentException("span wrapper didn't return a span: " + ShimUtil.className(wrapped));
            }
            throw new IllegalArgumentException("span is not a valid SpanShim object: " + ShimUtil.className(span));
        }
        return (SpanShim)span;
    }

    private static String className(@Nullable Object o) {
        return o == null ? "null" : o.getClass().getName();
    }
}

