/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.OpenTracingPropagators;
import io.opentelemetry.opentracingshim.ScopeShim;
import io.opentelemetry.opentracingshim.ShimUtil;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import javax.annotation.Nullable;

final class ScopeManagerShim
extends BaseShimObject
implements ScopeManager {
    private static final SpanShim NOOP_SPANSHIM = new SpanShim(new TelemetryInfo(OpenTelemetry.noop().getTracer("noop"), OpenTracingPropagators.builder().build()), Span.getInvalid());

    public ScopeManagerShim(TelemetryInfo telemetryInfo) {
        super(telemetryInfo);
    }

    @Nullable
    public io.opentracing.Span activeSpan() {
        SpanShim spanShim = SpanShim.current();
        Span span = null;
        span = spanShim == null ? Span.current() : spanShim.getSpan();
        if (!span.getSpanContext().isValid()) {
            return null;
        }
        if (spanShim != null && span == Span.current()) {
            return spanShim;
        }
        return new SpanShim(this.telemetryInfo(), span);
    }

    public Scope activate(@Nullable io.opentracing.Span span) {
        if (span == null) {
            return new ScopeShim(Context.current().with((ImplicitContextKeyed)NOOP_SPANSHIM).makeCurrent());
        }
        return new ScopeShim(Context.current().with((ImplicitContextKeyed)ShimUtil.getSpanShim(span)).makeCurrent());
    }
}

