/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.opentracingshim.OpenTracingPropagators;
import java.util.Objects;

public class OpenTracingPropagatorsBuilder {
    private TextMapPropagator textMapPropagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
    private TextMapPropagator httpHeadersPropagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();

    public OpenTracingPropagatorsBuilder setTextMap(TextMapPropagator textMapPropagator) {
        Objects.requireNonNull(textMapPropagator, "textMapPropagator");
        this.textMapPropagator = textMapPropagator;
        return this;
    }

    public OpenTracingPropagatorsBuilder setHttpHeaders(TextMapPropagator httpHeadersPropagator) {
        Objects.requireNonNull(httpHeadersPropagator, "httpHeadersPropagator");
        this.httpHeadersPropagator = httpHeadersPropagator;
        return this;
    }

    public OpenTracingPropagators build() {
        return new OpenTracingPropagators(this.textMapPropagator, this.httpHeadersPropagator);
    }
}

