/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class Propagation
extends BaseShimObject {
    private static final TextMapSetter SETTER_INSTANCE = new TextMapSetter();
    private static final TextMapGetter GETTER_INSTANCE = new TextMapGetter();

    Propagation(TelemetryInfo telemetryInfo) {
        super(telemetryInfo);
    }

    <C> void injectTextMap(SpanContextShim contextShim, Format<C> format, TextMapInject carrier) {
        Context context = Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)contextShim.getSpanContext()));
        context = context.with((ImplicitContextKeyed)contextShim.getBaggage());
        this.getPropagator(format).inject(context, (Object)carrier, (io.opentelemetry.context.propagation.TextMapSetter)SETTER_INSTANCE);
    }

    @Nullable
    <C> SpanContextShim extractTextMap(Format<C> format, TextMapExtract carrier) {
        HashMap<String, String> carrierMap = new HashMap<String, String>();
        for (Map.Entry entry : carrier) {
            carrierMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        Context context = this.getPropagator(format).extract(Context.current(), carrierMap, (io.opentelemetry.context.propagation.TextMapGetter)GETTER_INSTANCE);
        Span span = Span.fromContext((Context)context);
        Baggage baggage = Baggage.fromContext((Context)context);
        if (!span.getSpanContext().isValid() && baggage.isEmpty()) {
            return null;
        }
        return new SpanContextShim(this.telemetryInfo, span.getSpanContext(), baggage);
    }

    private <C> TextMapPropagator getPropagator(Format<C> format) {
        if (format == Format.Builtin.HTTP_HEADERS) {
            return this.propagators().httpHeadersPropagator();
        }
        return this.propagators().textMapPropagator();
    }

    static final class TextMapSetter
    implements io.opentelemetry.context.propagation.TextMapSetter<TextMapInject> {
        private TextMapSetter() {
        }

        public void set(@Nullable TextMapInject carrier, String key, String value) {
            if (carrier != null) {
                carrier.put(key, value);
            }
        }
    }

    static final class TextMapGetter
    implements io.opentelemetry.context.propagation.TextMapGetter<Map<String, String>> {
        private TextMapGetter() {
        }

        public Iterable<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }

        @Nullable
        public String get(@Nullable Map<String, String> carrier, String key) {
            if (carrier == null) {
                return null;
            }
            for (Map.Entry<String, String> entry : carrier.entrySet()) {
                if (!key.equalsIgnoreCase(entry.getKey())) continue;
                return entry.getValue();
            }
            return null;
        }
    }
}

