/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.opentracingshim.NoopSpanBuilderShim;
import io.opentelemetry.opentracingshim.Propagation;
import io.opentelemetry.opentracingshim.ScopeManagerShim;
import io.opentelemetry.opentracingshim.ShimUtil;
import io.opentelemetry.opentracingshim.SpanBuilderShim;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class TracerShim
implements Tracer {
    private static final Logger logger = Logger.getLogger(TracerShim.class.getName());
    private final TracerProvider provider;
    private final io.opentelemetry.api.trace.Tracer tracer;
    private final ScopeManager scopeManagerShim;
    private final Propagation propagation;
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    TracerShim(TracerProvider provider, TextMapPropagator textMapPropagator, TextMapPropagator httpPropagator) {
        this.provider = provider;
        this.tracer = provider.get("opentracing-shim", "1.34.1");
        this.propagation = new Propagation(textMapPropagator, httpPropagator);
        this.scopeManagerShim = new ScopeManagerShim();
    }

    io.opentelemetry.api.trace.Tracer tracer() {
        return this.tracer;
    }

    Propagation propagation() {
        return this.propagation;
    }

    public ScopeManager scopeManager() {
        return this.scopeManagerShim;
    }

    public Span activeSpan() {
        return this.scopeManagerShim.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.scopeManagerShim.activate(span);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        if (this.isShutdown.get()) {
            return new NoopSpanBuilderShim(operationName);
        }
        return new SpanBuilderShim(this.tracer, operationName);
    }

    public <C> void inject(SpanContext context, Format<C> format, C carrier) {
        if (context == null) {
            logger.log(Level.INFO, "Cannot inject a null span context.");
            return;
        }
        SpanContextShim contextShim = ShimUtil.getContextShim(context);
        if (contextShim == null) {
            return;
        }
        if (format == Format.Builtin.TEXT_MAP || format == Format.Builtin.TEXT_MAP_INJECT || format == Format.Builtin.HTTP_HEADERS) {
            this.propagation.injectTextMap(contextShim, format, (TextMapInject)carrier);
        }
    }

    @Nullable
    public <C> SpanContext extract(Format<C> format, C carrier) {
        try {
            if (format == Format.Builtin.TEXT_MAP || format == Format.Builtin.TEXT_MAP_EXTRACT || format == Format.Builtin.HTTP_HEADERS) {
                return this.propagation.extractTextMap(format, (TextMapExtract)carrier);
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.INFO, "Exception caught while extracting span context; returning null. Exception: [{0}] Message: [{1}]", new String[]{e.getClass().getName(), e.getMessage()});
        }
        return null;
    }

    public void close() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            return;
        }
        TracerProvider provider = TracerShim.maybeUnobfuscate(this.provider);
        if (provider instanceof Closeable) {
            try {
                ((Closeable)provider).close();
            }
            catch (IOException | RuntimeException e) {
                logger.log(Level.INFO, "Exception caught while closing TracerProvider.", e);
            }
        }
    }

    private static TracerProvider maybeUnobfuscate(TracerProvider tracerProvider) {
        if (!tracerProvider.getClass().getSimpleName().equals("ObfuscatedTracerProvider")) {
            return tracerProvider;
        }
        try {
            Field delegateField = tracerProvider.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            Object delegate = delegateField.get(tracerProvider);
            if (delegate instanceof TracerProvider) {
                return (TracerProvider)delegate;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.log(Level.INFO, "Error trying to unobfuscate SdkTracerProvider", e);
        }
        return tracerProvider;
    }
}

