/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.opentracingshim.BaseShimObject;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentelemetry.opentracingshim.TelemetryInfo;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SpanBuilderShim
extends BaseShimObject
implements Tracer.SpanBuilder {
    private final String spanName;
    @Nullable
    private SpanShim parentSpan;
    @Nullable
    private SpanContextShim parentSpanContext;
    private boolean ignoreActiveSpan;
    private final List<SpanContext> parentLinks = new ArrayList<SpanContext>();
    private final List<AttributeKey> spanBuilderAttributeKeys = new ArrayList<AttributeKey>();
    private final List<Object> spanBuilderAttributeValues = new ArrayList<Object>();
    @Nullable
    private SpanKind spanKind;
    private boolean error;
    private long startTimestampMicros;

    public SpanBuilderShim(TelemetryInfo telemetryInfo, String spanName) {
        super(telemetryInfo);
        this.spanName = spanName;
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.Span parent) {
        if (parent == null) {
            return this;
        }
        SpanShim spanShim = SpanBuilderShim.getSpanShim(parent);
        if (this.parentSpan == null && this.parentSpanContext == null) {
            this.parentSpan = spanShim;
        } else {
            this.parentLinks.add(spanShim.getSpan().getSpanContext());
        }
        return this;
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
        return this.addReference(null, parent);
    }

    public Tracer.SpanBuilder addReference(@Nullable String referenceType, io.opentracing.SpanContext referencedContext) {
        if (referencedContext == null) {
            return this;
        }
        SpanContextShim contextShim = SpanBuilderShim.getContextShim(referencedContext);
        if (this.parentSpan == null && this.parentSpanContext == null) {
            this.parentSpanContext = contextShim;
        } else {
            this.parentLinks.add(contextShim.getSpanContext());
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        if (Tags.SPAN_KIND.getKey().equals(key)) {
            switch (value) {
                case "client": {
                    this.spanKind = SpanKind.CLIENT;
                    break;
                }
                case "server": {
                    this.spanKind = SpanKind.SERVER;
                    break;
                }
                case "producer": {
                    this.spanKind = SpanKind.PRODUCER;
                    break;
                }
                case "consumer": {
                    this.spanKind = SpanKind.CONSUMER;
                    break;
                }
                default: {
                    this.spanKind = SpanKind.INTERNAL;
                    break;
                }
            }
        } else if (Tags.ERROR.getKey().equals(key)) {
            this.error = Boolean.parseBoolean(value);
        } else {
            this.spanBuilderAttributeKeys.add(AttributeKey.stringKey((String)key));
            this.spanBuilderAttributeValues.add(value);
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key)) {
            this.error = value;
        } else {
            this.spanBuilderAttributeKeys.add(AttributeKey.booleanKey((String)key));
            this.spanBuilderAttributeValues.add(value);
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        if (value == null) {
            return this;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            this.spanBuilderAttributeKeys.add(AttributeKey.longKey((String)key));
            this.spanBuilderAttributeValues.add(value.longValue());
        } else if (value instanceof Float || value instanceof Double) {
            this.spanBuilderAttributeKeys.add(AttributeKey.doubleKey((String)key));
            this.spanBuilderAttributeValues.add(value.doubleValue());
        } else {
            throw new IllegalArgumentException("Number type not supported");
        }
        return this;
    }

    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        if (tag == null) {
            return this;
        }
        if (value instanceof String) {
            this.withTag(tag.getKey(), (String)value);
        } else if (value instanceof Boolean) {
            this.withTag(tag.getKey(), (Boolean)value);
        } else if (value instanceof Number) {
            this.withTag(tag.getKey(), (Number)value);
        } else {
            this.withTag(tag.getKey(), value.toString());
        }
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.startTimestampMicros = microseconds;
        return this;
    }

    public io.opentracing.Span start() {
        Baggage baggage = null;
        SpanBuilder builder = this.tracer().spanBuilder(this.spanName);
        if (this.ignoreActiveSpan && this.parentSpan == null && this.parentSpanContext == null) {
            builder.setNoParent();
        } else if (this.parentSpan != null) {
            builder.setParent(Context.root().with((ImplicitContextKeyed)this.parentSpan.getSpan()));
            SpanContextShim contextShim = this.spanContextTable().get(this.parentSpan);
            baggage = contextShim == null ? null : contextShim.getBaggage();
        } else if (this.parentSpanContext != null) {
            builder.setParent(Context.root().with((ImplicitContextKeyed)Span.wrap((SpanContext)this.parentSpanContext.getSpanContext())));
            baggage = this.parentSpanContext.getBaggage();
        }
        for (SpanContext link : this.parentLinks) {
            builder.addLink(link);
        }
        if (this.spanKind != null) {
            builder.setSpanKind(this.spanKind);
        }
        if (this.startTimestampMicros > 0L) {
            builder.setStartTimestamp(this.startTimestampMicros, TimeUnit.MICROSECONDS);
        }
        Span span = builder.startSpan();
        for (int i = 0; i < this.spanBuilderAttributeKeys.size(); ++i) {
            AttributeKey key = this.spanBuilderAttributeKeys.get(i);
            Object value = this.spanBuilderAttributeValues.get(i);
            span.setAttribute(key, value);
        }
        if (this.error) {
            span.setStatus(StatusCode.ERROR);
        }
        SpanShim spanShim = new SpanShim(this.telemetryInfo(), span);
        if (baggage != null && baggage != this.telemetryInfo().emptyBaggage()) {
            this.spanContextTable().create(spanShim, baggage);
        }
        return spanShim;
    }

    private static SpanShim getSpanShim(io.opentracing.Span span) {
        if (!(span instanceof SpanShim)) {
            throw new IllegalArgumentException("span is not a valid SpanShim object");
        }
        return (SpanShim)span;
    }

    private static SpanContextShim getContextShim(io.opentracing.SpanContext context) {
        if (!(context instanceof SpanContextShim)) {
            throw new IllegalArgumentException("context is not a valid SpanContextShim object");
        }
        return (SpanContextShim)context;
    }
}

