/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public abstract class ComponentRegistry<V> {
    private final ConcurrentMap<InstrumentationLibraryInfo, V> registry = new ConcurrentHashMap<InstrumentationLibraryInfo, V>();

    public final V get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    public final V get(String instrumentationName, @Nullable String instrumentationVersion) {
        InstrumentationLibraryInfo instrumentationLibraryInfo = InstrumentationLibraryInfo.create(instrumentationName, instrumentationVersion);
        Object component = this.registry.get(instrumentationLibraryInfo);
        if (component != null) {
            return component;
        }
        V newComponent = this.newComponent(instrumentationLibraryInfo);
        V oldComponent = this.registry.putIfAbsent(instrumentationLibraryInfo, newComponent);
        return oldComponent != null ? oldComponent : newComponent;
    }

    public final Collection<V> getComponents() {
        return Collections.unmodifiableCollection(new ArrayList(this.registry.values()));
    }

    public abstract V newComponent(InstrumentationLibraryInfo var1);
}

