/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.common.export;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ConfigBuilder<T> {
    protected abstract T fromConfigMap(Map<String, String> var1, NamingConvention var2);

    public T readProperties(Properties properties) {
        Properties map = properties;
        return this.fromConfigMap(map, NamingConvention.DOT);
    }

    public T readEnvironmentVariables() {
        return this.fromConfigMap(System.getenv(), NamingConvention.ENV_VAR);
    }

    public T readSystemProperties() {
        return this.readProperties(System.getProperties());
    }

    @Nullable
    protected static Boolean getBooleanProperty(String name, Map<String, String> map) {
        if (map.containsKey(name)) {
            return Boolean.parseBoolean(map.get(name));
        }
        return null;
    }

    @Nullable
    protected static Integer getIntProperty(String name, Map<String, String> map) {
        try {
            return Integer.parseInt(map.get(name));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Nullable
    protected static Long getLongProperty(String name, Map<String, String> map) {
        try {
            return Long.parseLong(map.get(name));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Nullable
    protected static String getStringProperty(String name, Map<String, String> map) {
        return map.get(name);
    }

    @Nullable
    protected static Double getDoubleProperty(String name, Map<String, String> map) {
        try {
            return Double.parseDouble(map.get(name));
        }
        catch (NullPointerException | NumberFormatException ex) {
            return null;
        }
    }

    protected static enum NamingConvention {
        DOT{

            @Override
            public String normalize(@Nonnull String key) {
                return key.toLowerCase();
            }
        }
        ,
        ENV_VAR{

            @Override
            public String normalize(@Nonnull String key) {
                return key.toLowerCase().replace("_", ".");
            }
        };


        public abstract String normalize(@Nonnull String var1);

        public Map<String, String> normalize(@Nonnull Map<String, String> map) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                properties.put(this.normalize(entry.getKey()), entry.getValue());
            }
            return Collections.unmodifiableMap(properties);
        }
    }
}

