/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.resources.AutoValue_ResourcesConfig;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class ResourcesConfig {
    private static final ResourcesConfig DEFAULT = ResourcesConfig.newBuilder().build();

    public static ResourcesConfig getDefault() {
        return DEFAULT;
    }

    public abstract Set<String> getDisabledResourceProviders();

    public static Builder newBuilder() {
        return new AutoValue_ResourcesConfig.Builder().setDisabledResourceProviders((Set<String>)ImmutableSet.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder
    extends ConfigBuilder<Builder> {
        private static final String OTEL_JAVA_DISABLED_RESOURCES_PROVIDERS = "otel.java.disabled.resource_providers";

        Builder() {
        }

        @Override
        @VisibleForTesting
        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            String stringValue = Builder.getStringProperty(OTEL_JAVA_DISABLED_RESOURCES_PROVIDERS, configMap = namingConvention.normalize(configMap));
            if (stringValue != null) {
                this.setDisabledResourceProviders((Set<String>)ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)stringValue)));
            }
            return this;
        }

        public abstract Builder setDisabledResourceProviders(Set<String> var1);

        abstract ResourcesConfig autoBuild();

        public ResourcesConfig build() {
            ResourcesConfig resourcesConfig = this.autoBuild();
            Preconditions.checkArgument((resourcesConfig.getDisabledResourceProviders() != null ? 1 : 0) != 0, (Object)"disabledResourceProviders");
            return resourcesConfig;
        }
    }
}

