/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ComponentRegistry<V> {
    private final ConcurrentMap<InstrumentationLibraryInfo, V> registry = new ConcurrentHashMap<InstrumentationLibraryInfo, V>();
    private final Function<InstrumentationLibraryInfo, V> factory;

    public ComponentRegistry(Function<InstrumentationLibraryInfo, V> factory) {
        this.factory = factory;
    }

    public V get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    public V get(String instrumentationName, @Nullable String instrumentationVersion) {
        return this.get(instrumentationName, instrumentationVersion, null);
    }

    public V get(String instrumentationName, @Nullable String instrumentationVersion, @Nullable String schemaUrl) {
        InstrumentationLibraryInfo instrumentationLibraryInfo = InstrumentationLibraryInfo.create(instrumentationName, instrumentationVersion, schemaUrl);
        Object component = this.registry.get(instrumentationLibraryInfo);
        if (component != null) {
            return component;
        }
        V newComponent = this.factory.apply(instrumentationLibraryInfo);
        V oldComponent = this.registry.putIfAbsent(instrumentationLibraryInfo, newComponent);
        return oldComponent != null ? oldComponent : newComponent;
    }

    public Collection<V> getComponents() {
        return Collections.unmodifiableCollection(new ArrayList(this.registry.values()));
    }
}

