/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.sdk.autoconfigure.ConfigurationException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ConfigProperties {
    private final Map<String, String> config;

    static ConfigProperties get() {
        return new ConfigProperties(System.getProperties(), System.getenv());
    }

    static ConfigProperties createForTest(Map<String, String> properties) {
        return new ConfigProperties(properties, Collections.emptyMap());
    }

    private ConfigProperties(Map<?, ?> systemProperties, Map<String, String> environmentVariables) {
        HashMap<String, String> config = new HashMap<String, String>();
        environmentVariables.forEach((name, value) -> config.put(name.toLowerCase(Locale.ROOT).replace('_', '.'), (String)value));
        systemProperties.forEach((key, value) -> config.put(((String)key).toLowerCase(Locale.ROOT), (String)value));
        this.config = config;
    }

    @Nullable
    public String getString(String name) {
        return this.config.get(name);
    }

    @Nullable
    public Integer getInt(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw ConfigProperties.newInvalidPropertyException(name, value, "integer");
        }
    }

    @Nullable
    public Long getLong(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw ConfigProperties.newInvalidPropertyException(name, value, "long");
        }
    }

    @Nullable
    public Double getDouble(String name) {
        String value = this.config.get(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw ConfigProperties.newInvalidPropertyException(name, value, "double");
        }
    }

    public List<String> getCommaSeparatedValues(String name) {
        String value = this.config.get(name);
        if (value == null) {
            return Collections.emptyList();
        }
        return ConfigProperties.filterBlanksAndNulls(value.split(","));
    }

    public Map<String, String> getCommaSeparatedMap(String name) {
        return this.getCommaSeparatedValues(name).stream().map(keyValuePair -> ConfigProperties.filterBlanksAndNulls(keyValuePair.split("=", 2))).map(splitKeyValuePairs -> {
            if (splitKeyValuePairs.size() != 2) {
                throw new ConfigurationException("Invalid map property: " + name + "=" + this.config.get(name));
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.config.get(name));
    }

    private static ConfigurationException newInvalidPropertyException(String name, String value, String type) {
        throw new ConfigurationException("Invalid value for property " + name + "=" + value + ". Must be a " + type + ".");
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

