/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.SpanExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.config.TraceConfigBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.ServiceLoader;

final class TracerProviderConfiguration {
    static SdkTracerProvider configureTracerProvider(Resource resource, ConfigProperties config) {
        SpanExporter exporter;
        SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder().setResource(resource).setTraceConfig(TracerProviderConfiguration.configureTraceConfig(config));
        String sampler = config.getString("otel.trace.sampler");
        if (sampler != null) {
            tracerProviderBuilder.setSampler(TracerProviderConfiguration.configureSampler(sampler, config));
        }
        for (SdkTracerProviderConfigurer configurer : ServiceLoader.load(SdkTracerProviderConfigurer.class)) {
            configurer.configure(tracerProviderBuilder);
        }
        String exporterName = config.getString("otel.trace.exporter");
        if (exporterName != null && (exporter = SpanExporterConfiguration.configureExporter(exporterName, config)) != null) {
            tracerProviderBuilder.addSpanProcessor((SpanProcessor)TracerProviderConfiguration.configureSpanProcessor(config, exporter));
        }
        SdkTracerProvider tracerProvider = tracerProviderBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)tracerProvider).shutdown()));
        return tracerProvider;
    }

    static BatchSpanProcessor configureSpanProcessor(ConfigProperties config, SpanExporter exporter) {
        Integer timeout;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder((SpanExporter)exporter);
        Long scheduleDelayMillis = config.getLong("otel.bsp.schedule.delay");
        if (scheduleDelayMillis != null) {
            builder.setScheduleDelay(Duration.ofMillis(scheduleDelayMillis));
        }
        if ((maxQueue = config.getInt("otel.bsp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue.intValue());
        }
        if ((maxExportBatch = config.getInt("otel.bsp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch.intValue());
        }
        if ((timeout = config.getInt("otel.bsp.export.timeout")) != null) {
            builder.setExporterTimeout(Duration.ofMillis(timeout.intValue()));
        }
        return builder.build();
    }

    static TraceConfig configureTraceConfig(ConfigProperties config) {
        Integer maxLinks;
        Integer maxEvents;
        TraceConfigBuilder builder = TraceConfig.builder();
        Integer maxAttrs = config.getInt("otel.span.attribute.count.limit");
        if (maxAttrs != null) {
            builder.setMaxNumberOfAttributes(maxAttrs.intValue());
        }
        if ((maxEvents = config.getInt("otel.span.event.count.limit")) != null) {
            builder.setMaxNumberOfEvents(maxEvents.intValue());
        }
        if ((maxLinks = config.getInt("otel.span.link.count.limit")) != null) {
            builder.setMaxNumberOfLinks(maxLinks.intValue());
        }
        return builder.build();
    }

    static Sampler configureSampler(String sampler, ConfigProperties config) {
        switch (sampler) {
            case "always_on": {
                return Sampler.alwaysOn();
            }
            case "always_off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": {
                Double ratio = config.getDouble("otel.trace.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.traceIdRatioBased((double)ratio);
            }
            case "parentbased_always_on": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOn());
            }
            case "parentbased_always_off": {
                return Sampler.parentBased((Sampler)Sampler.alwaysOff());
            }
            case "parentbased_traceidratio": {
                Double ratio = config.getDouble("otel.trace.sampler.arg");
                if (ratio == null) {
                    ratio = 1.0;
                }
                return Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)ratio));
            }
        }
        throw new ConfigurationException("Unrecognized value for otel.trace.sampler: " + sampler);
    }

    private TracerProviderConfiguration() {
    }
}

