/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.MetricExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.PropagatorConfiguration;
import io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;

public final class OpenTelemetrySdkAutoConfiguration {
    public static OpenTelemetrySdk initialize() {
        ConfigProperties config = ConfigProperties.get();
        ContextPropagators propagators = PropagatorConfiguration.configurePropagators(config);
        Resource resource = Resource.getDefault();
        OpenTelemetrySdkAutoConfiguration.configureMeterProvider(resource, config);
        SdkTracerProvider tracerProvider = TracerProviderConfiguration.configureTracerProvider(resource, config);
        return OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(propagators).buildAndRegisterGlobal();
    }

    private static void configureMeterProvider(Resource resource, ConfigProperties config) {
        SdkMeterProvider meterProvider = SdkMeterProvider.builder().setResource(resource).buildAndRegisterGlobal();
        String exporterName = config.getString("otel.metrics.exporter");
        if (exporterName != null) {
            MetricExporterConfiguration.configureExporter(exporterName, config, meterProvider);
        }
    }

    private OpenTelemetrySdkAutoConfiguration() {
    }
}

