/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.logging.LoggingMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.grpc.DefaultGrpcExporterBuilder;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

final class MetricExporterConfiguration {
    static void configureExporter(String name, ConfigProperties config, ClassLoader serviceClassLoader, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        switch (name) {
            case "otlp": {
                MetricExporterConfiguration.configureOtlpMetrics(config, sdkMeterProviderBuilder);
                return;
            }
            case "prometheus": {
                MetricExporterConfiguration.configurePrometheusMetrics(config, sdkMeterProviderBuilder);
                return;
            }
            case "logging": {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingMetricExporter", "Logging Metrics Exporter", "opentelemetry-exporter-logging");
                MetricExporterConfiguration.configureLoggingMetrics(config, sdkMeterProviderBuilder);
                return;
            }
        }
        MetricExporter spiExporter = MetricExporterConfiguration.configureSpiExporter(name, config, serviceClassLoader);
        if (spiExporter == null) {
            throw new ConfigurationException("Unrecognized value for otel.metrics.exporter: " + name);
        }
        MetricExporterConfiguration.configurePeriodicMetricReader(config, sdkMeterProviderBuilder, spiExporter);
    }

    @Nullable
    static MetricExporter configureSpiExporter(String name, ConfigProperties config, ClassLoader serviceClassLoader) {
        Map<String, MetricExporter> spiExporters = SpiUtil.loadConfigurable(ConfigurableMetricExporterProvider.class, Collections.singletonList(name), ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config, serviceClassLoader);
        return spiExporters.get(name);
    }

    private static void configureLoggingMetrics(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        MetricExporterConfiguration.configurePeriodicMetricReader(config, sdkMeterProviderBuilder, (MetricExporter)LoggingMetricExporter.create());
    }

    @Nullable
    static MetricExporter configureOtlpMetrics(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        OtlpHttpMetricExporter exporter;
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter", "OTLP HTTP Metrics Exporter", "opentelemetry-exporter-otlp-http-metrics");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpHttpMetricExporterBuilder builder = OtlpHttpMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTrustedCertificates(arg_0), unused -> {});
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setPreferredTemporality(arg_0));
            exporter = builder.build();
        } else if (protocol.equals("grpc")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter", "OTLP gRPC Metrics Exporter", "opentelemetry-exporter-otlp-metrics");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTrustedCertificates(arg_0), retryPolicy -> DefaultGrpcExporterBuilder.getDelegateBuilder(OtlpGrpcMetricExporterBuilder.class, (Object)builder).addRetryPolicy(retryPolicy));
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setPreferredTemporality(arg_0));
            exporter = builder.build();
        } else {
            throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
        }
        MetricExporterConfiguration.configurePeriodicMetricReader(config, sdkMeterProviderBuilder, (MetricExporter)exporter);
        return exporter;
    }

    private static void configurePeriodicMetricReader(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder, MetricExporter exporter) {
        Duration exportInterval = config.getDuration("otel.metric.export.interval");
        if (exportInterval == null) {
            exportInterval = config.getDuration("otel.imr.export.interval");
        }
        if (exportInterval == null) {
            exportInterval = Duration.ofMinutes(1L);
        }
        sdkMeterProviderBuilder.registerMetricReader(PeriodicMetricReader.builder((MetricExporter)exporter).setInterval(exportInterval).newMetricReaderFactory());
    }

    private static void configurePrometheusMetrics(ConfigProperties config, SdkMeterProviderBuilder sdkMeterProviderBuilder) {
        String host;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.prometheus.PrometheusHttpServer", "Prometheus Metrics Server", "opentelemetry-exporter-prometheus");
        PrometheusHttpServerBuilder prom = PrometheusHttpServer.builder();
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port != null) {
            prom.setPort(port.intValue());
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) != null) {
            prom.setHost(host);
        }
        sdkMeterProviderBuilder.registerMetricReader(prom.newMetricReaderFactory());
    }

    private MetricExporterConfiguration() {
    }
}

