/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.grpc.DefaultGrpcExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

final class SpanExporterConfiguration {
    private static final String EXPORTER_NONE = "none";

    static Map<String, SpanExporter> configureSpanExporters(ConfigProperties config, ClassLoader serviceClassLoader, MeterProvider meterProvider, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer) {
        List exporterNamesList = config.getList("otel.traces.exporter");
        Set<Object> exporterNames = new HashSet(exporterNamesList);
        if (exporterNamesList.size() != exporterNames.size()) {
            String duplicates = exporterNamesList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]"));
            throw new ConfigurationException("otel.traces.exporter contains duplicates: " + duplicates);
        }
        if (exporterNames.contains(EXPORTER_NONE)) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.traces.exporter contains none along with other exporters");
            }
            SpanExporter noop = SpanExporter.composite((SpanExporter[])new SpanExporter[0]);
            SpanExporter customized = spanExporterCustomizer.apply((SpanExporter)noop, config);
            if (customized == noop) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(EXPORTER_NONE, customized);
        }
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton("otlp");
        }
        Map<String, SpanExporter> spiExporters = SpiUtil.loadConfigurable(ConfigurableSpanExporterProvider.class, exporterNamesList, ConfigurableSpanExporterProvider::getName, ConfigurableSpanExporterProvider::createExporter, config, serviceClassLoader);
        return exporterNames.stream().collect(Collectors.toMap(Function.identity(), exporterName -> (SpanExporter)spanExporterCustomizer.apply(SpanExporterConfiguration.configureExporter(exporterName, config, spiExporters, meterProvider), config)));
    }

    static SpanExporter configureExporter(String name, ConfigProperties config, Map<String, SpanExporter> spiExporters, MeterProvider meterProvider) {
        switch (name) {
            case "otlp": {
                return SpanExporterConfiguration.configureOtlp(config, meterProvider);
            }
            case "jaeger": {
                return SpanExporterConfiguration.configureJaeger(config);
            }
            case "zipkin": {
                return SpanExporterConfiguration.configureZipkin(config);
            }
            case "logging": {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingSpanExporter", "Logging Trace Exporter", "opentelemetry-exporter-logging");
                return LoggingSpanExporter.create();
            }
        }
        SpanExporter spiExporter = spiExporters.get(name);
        if (spiExporter == null) {
            throw new ConfigurationException("Unrecognized value for otel.traces.exporter: " + name);
        }
        return spiExporter;
    }

    static SpanExporter configureOtlp(ConfigProperties config, MeterProvider meterProvider) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("traces", config);
        if (protocol.equals("http/protobuf")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter", "OTLP HTTP Trace Exporter", "opentelemetry-exporter-otlp-http-trace");
            OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setTrustedCertificates(arg_0), unused -> {});
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter", "OTLP gRPC Trace Exporter", "opentelemetry-exporter-otlp");
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setTrustedCertificates(arg_0), retryPolicy -> DefaultGrpcExporterBuilder.getDelegateBuilder(OtlpGrpcSpanExporterBuilder.class, (Object)builder).addRetryPolicy(retryPolicy));
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP traces protocol: " + protocol);
    }

    private static SpanExporter configureJaeger(ConfigProperties config) {
        Duration timeout;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter", "Jaeger gRPC Exporter", "opentelemetry-exporter-jaeger");
        JaegerGrpcSpanExporterBuilder builder = JaegerGrpcSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.jaeger.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.jaeger.timeout")) != null) {
            builder.setTimeout(timeout);
        }
        return builder.build();
    }

    private static SpanExporter configureZipkin(ConfigProperties config) {
        Duration timeout;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.zipkin.ZipkinSpanExporter", "Zipkin Exporter", "opentelemetry-exporter-zipkin");
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.zipkin.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.zipkin.timeout")) != null) {
            builder.setReadTimeout(timeout);
        }
        return builder.build();
    }

    private SpanExporterConfiguration() {
    }
}

