/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

final class ResourceConfiguration {
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";

    static Resource configureResource(ConfigProperties config, BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Resource result = Resource.getDefault();
        HashSet disabledProviders = new HashSet(config.getList("otel.java.disabled.resource.providers"));
        for (ResourceProvider resourceProvider : ServiceLoader.load(ResourceProvider.class)) {
            if (disabledProviders.contains(resourceProvider.getClass().getName())) continue;
            result = result.merge(resourceProvider.createResource(config));
        }
        result = result.merge(ResourceConfiguration.createEnvironmentResource(config));
        return resourceCustomizer.apply((Resource)result, config);
    }

    private static Resource createEnvironmentResource(ConfigProperties config) {
        return Resource.create((Attributes)ResourceConfiguration.getAttributes(config), (String)"https://opentelemetry.io/schemas/1.8.0");
    }

    static Attributes getAttributes(ConfigProperties configProperties) {
        AttributesBuilder resourceAttributes = Attributes.builder();
        configProperties.getMap(ATTRIBUTE_PROPERTY).forEach((arg_0, arg_1) -> ((AttributesBuilder)resourceAttributes).put(arg_0, arg_1));
        String serviceName = configProperties.getString(SERVICE_NAME_PROPERTY);
        if (serviceName != null) {
            resourceAttributes.put(ResourceAttributes.SERVICE_NAME, (Object)serviceName);
        }
        return resourceAttributes.build();
    }

    private ResourceConfiguration() {
    }
}

